# coding=utf-8
from __future__ import unicode_literals, print_function, absolute_import

import datetime
import os
from celery.schedules import crontab

from kombu import Exchange, Queue
from mobile.libs.hospital_synonym import get_synonym
from gm_types.gaia import TRANSFER_SOURCE
from gm_types.mimas import GRABBING_PLATFORM

############################################### django ###############################################
ALLOWED_HOSTS = ['*']
BASE_DIR = os.path.dirname(os.path.dirname(__file__))
DATABASES = {
    'default': {
        'ENGINE': 'django.db.backends.sqlite3',
        'NAME': ':memory:',
    },
}
DEBUG = True
DEFAULT_JINJA2_TEMPLATE_EXTENSION = ''

# Application definition

INSTALLED_APPS = (
    'django.contrib.contenttypes',
    'django.contrib.sessions',
    'django.contrib.staticfiles',
    'django_jinja',
    'mobile',
    'raven.contrib.django.raven_compat',
)
LANGUAGE_CODE = 'en-us'
MIDDLEWARE_CLASSES = (
    'gm_tracer.middleware.TracerMiddleware',
    'gm_tracer.middleware.TracerExtraMiddleware',
    'mobile.middlewares.LoggingMiddleware',
    'django.middleware.common.CommonMiddleware',
    #'django.middleware.csrf.CsrfViewMiddleware',
    'django.contrib.sessions.middleware.SessionMiddleware',
    'gm_logging.django.middleware.LoggingMiddleware',
    'mobile.middlewares.HeliosMiddleware',
    'mobile.middlewares.PassportMiddleware',
    'mobile.middlewares.TrackingMiddleware',
    'gm_shield.django.middleware.GMShield',
)
ROOT_URLCONF = 'ship.urls'
SECRET_KEY = '1j%gt4=0e6l9)z1k9pr$b$9s%4ic=@xf5083tcq*k040rk6=hh'

SESSION_COOKIE_NAME = 'django_sessionid'
SESSION_ENGINE = 'redis_sessions.session'
SESSION_NAME = 'sessionid'
SESSION_REDIS_HOST = '192.168.168.142'
SESSION_REDIS_PORT = 6379
SESSION_REDIS_DB = 1
SESSION_REDIS_PREFIX = 'msite'

STATICFILES_DIRS = (
    ("mobile", os.path.join(BASE_DIR, 'frontend', 'mobile', 'static', 'mobile')),
)
STATICFILES_FINDERS = (
    'django.contrib.staticfiles.finders.FileSystemFinder',
)
STATIC_ROOT = ''
STATIC_URL = '/static/'

TEMPLATE_DEBUG = DEBUG
TEMPLATE_DIRS = (
    os.path.join(BASE_DIR, 'frontend', 'mobile', 'templates'),
)
TEMPLATE_LOADERS = (
    'django_jinja.loaders.FileSystemLoader',
)

TIME_ZONE = 'Asia/Shanghai'
USE_I18N = True
USE_L10N = True
USE_TZ = True
WSGI_APPLICATION = 'ship.wsgi.application'
############################################### django ###############################################


############################################### others ###############################################
CELERY_DEFAULT_QUEUE = 'ship'
CELERY_QUEUES = (
    Queue('ship', Exchange('ship'), routing_key='ship'),
)
BROKER_TRANSPORT_OPTIONS = {'visibility_timeout': 60 * 60 * 24 * 3}
BROKER_URL = 'redis://192.168.168.142:6379/4'
RAVEN_CONFIG = ''
REDIS = {'host': '192.168.168.142', 'port': 6379, 'db': 0, }
REDIS_CONFIG = {
    'host': '192.168.168.142',
    'port': 6379,
    'db': 0,
}
TRACKING_COOKIE_AGE = 365 * 24 * 60 * 60
TRACKING_COOKIE_NAME = '_gtid'
CELERY_TIMEZONE = 'Asia/Shanghai'
CELERY_TASK_SERIALIZER = "json"
SENTRY_CELERY_ENDPOINT = ''

CELERYBEAT_SCHEDULE = {
    "cache_trilateral_seckill_base_info": {
        "task": "mobile.tasks.period_tasks.cache_trilateral_seckill_base_info",
        "schedule": datetime.timedelta(seconds=10),
        "args": (),
    },
    "cache_trilateral_seckill_city_info": {
        "task": "mobile.tasks.period_tasks.cache_trilateral_seckill_city_info",
        "schedule": datetime.timedelta(minutes=10),
        "args": (),
    },
}

############################################### others ###############################################
DEFAULT_PORTRAIT = 'http://hera.s.igengmei.com/slide/2016/11/30/07b076e423'
IMG_LAYER = 'http://hera.s.igengmei.com/2016/07/21/56dd662785'
IOS_DEFAULT_PARAM = '00000000-0000-0000-0000-000000000000'


IS_ACCEPT_CALL = False
TIME_CAN_ACCEPT_CALL = (datetime.time(9, 0, 0), datetime.time(19, 0, 0))

BACKEND_URL = 'http://backend.igengmei.com/'
PC_URL = 'http://www.igengmei.com'
SITE_URL = 'http://m.igengmei.com/'
URL_BASE = 'http://m.igengmei.com'

RENMAI_INSTALLMENT_PERIOD = 12
SERVICE_INSERT_INDEX = 3
SPECIAL_COUPON_CHANNEL = 22

TDK = {
    'title': u'更美APP官网—微整形_整形美购_整形美容_微整形社区与微整形特卖平台',
    'keywords': u'更美，更美APP，更美APP官网，更美网，整形，整容，微整形',
    'description': u'更美公司成立于2013年，旗下更美APP是专业微整形平台，提供整形、微整形、齿科、眼科、抗衰老等消费医疗服务。业务形态主要包括移动医美与健康社区、医美电商与团购特卖、企业服务、消费金融等。更美APP致力于帮助求美者更高效地找到合适的医生，降低消费风险；也帮助医生塑造个人品牌。'
}

WECHAT_APP_ID = ''
WECHAT_APP_SECRET = ''
WECHAT_PAY_REDIRECT_URL = ''
WX_APP_ID = ''
WX_APP_SECRET = ''

WECHATLINE_SCREENSHOT = {
    'title': "",
    'content': "http://hera.s.igengmei.com/slide/2016/06/02/6a6eb352d8"
}
WECHAT_SCREENSHOT = {
    'title': "",
    'content': "http://hera.s.igengmei.com/slide/2016/06/02/6a6eb352d8"
}

WEIBO_SHARE_HOST = u'http://m.igengmei.com'
##########################################################################################


############################################### logging ###############################################
LOG_DIR = '/data/log/ship/app/'
LOGGING = {
    'version': 1,
    'disable_existing_loggers': False,

    'formatters': {
        'verbose': {
            'format': '%(asctime)s %(levelname)s %(module)s.%(funcName)s Line:%(lineno)d  %(message)s'
        },
        'simple': {
            'format': '%(asctime)s %(levelname)s %(message)s'
        },
        'raw': {
            'format': '%(message)s'
        },
    },

    'handlers': {
        'null': {
            'level': 'DEBUG',
            'class': 'django.utils.log.NullHandler',
        },
        'console': {
            'level': 'DEBUG',
            'class': 'logging.StreamHandler',
            'formatter': 'simple'
        },
        'mail_admins': {
            'level': 'ERROR',
            'class': 'django.utils.log.AdminEmailHandler'
        },

        # 默认的服务器Log(保存到log/filelog.log中, 通过linux的logrotate来处理日志的分割
        'default': {
            'level': 'INFO',
            'class': 'logging.handlers.RotatingFileHandler',
            'filename': os.path.join(LOG_DIR, 'filelog.log'),
            'formatter': 'verbose',
        },

        # 默认的服务器ERROR log
        'default_err': {
            'level': 'ERROR',
            'class': 'logging.handlers.RotatingFileHandler',
            'filename': os.path.join(LOG_DIR, 'error_logger.log'),
            'formatter': 'verbose',
        },
        'exception_logger': {
            'level': 'INFO',
            'class': 'logging.handlers.RotatingFileHandler',
            'filename': os.path.join(LOG_DIR, 'exception_logger.log'),
            'formatter': 'verbose',
        },
        'info_logger': {
            'level': 'INFO',
            'class': 'logging.handlers.RotatingFileHandler',
            'filename': os.path.join(LOG_DIR, 'info_logger.log'),
            'formatter': 'verbose',
        },
        'profile_logger': {
            'level': 'INFO',
            'class': 'logging.handlers.RotatingFileHandler',
            'filename': os.path.join(LOG_DIR, 'profile_logger.log'),
            'formatter': 'simple',
        },
        'wx_download_pic_logger': {
            'level': 'INFO',
            'class': 'logging.handlers.RotatingFileHandler',
            'filename': os.path.join(LOG_DIR, 'wx_download_pic_logger.log'),
            'formatter': 'verbose',
        },
        'fxg_handler': {
            'level': 'INFO',
            'class': 'logging.handlers.RotatingFileHandler',
            'filename': os.path.join(LOG_DIR, 'fenxianggou_logger.log'),
            'formatter': 'simple',
        },
        'settlement_create_handler': {
            'level': 'INFO',
            'class': 'logging.handlers.RotatingFileHandler',
            'filename': os.path.join(LOG_DIR, 'settlement_create_logger.log'),
            'formatter': 'simple',
        },
        # 陌陌打点日志
        'momo_stat_log_handler': {
            'level': 'INFO',
            'class': 'logging.handlers.RotatingFileHandler',
            'filename': os.path.join(LOG_DIR, 'momo_stat_log.log'),
            'formatter': 'simple',
        },

        'tracer_handler': {
            'level': 'INFO',
            'class': 'logging.handlers.RotatingFileHandler',
            'filename': os.path.join(LOG_DIR, 'tracer.log'),
            'formatter': 'raw',
        },

        # 三方合作，秒杀基础数据缓存日志
        'trilateral_seckill_cache_handler': {
            'level': 'INFO',
            'class': 'logging.handlers.RotatingFileHandler',
            'filename': os.path.join(LOG_DIR, 'cache_trilateral_seckill_base_info.log'),
            'formatter': 'simple',
        },
        # 三方合作，手机号绑定出错日志
        'trilateral_user_bind_phone_handler': {
            'level': 'INFO',
            'class': 'logging.handlers.RotatingFileHandler',
            'filename': os.path.join(LOG_DIR, 'trilateral_user_bind_phone_logger.log'),
            'formatter': 'simple',
        },
    },
    'loggers': {
        # 默认都交给django了
        'django': {
            'handlers': ['default'],
            'propagate': True,
            'level': 'INFO',
        },
        'django.request': {
            'handlers': ['default_err'],
            'level': 'ERROR',
            'propagate': False,
        },
        'exception_logger': {
            'handlers': ['exception_logger'],
            'level': 'INFO',
            'propagate': False,
        },
        'info_logger': {
            'handlers': ['info_logger'],
            'level': 'INFO',
            'propagate': False,
        },
        'profile_logger': {
            'handlers': ['profile_logger'],
            'level': 'INFO',
            'propagate': False,
        },
        'err_logger': {
            "handlers": ['default_err'],
            'level': "ERROR",
            "propagate": False,
        },
        'wx_download_pic_logger': {
            'handlers': ['wx_download_pic_logger'],
            'level': 'INFO',
            'propagate': False,
        },
        'fxg_logger': {
            "handler": ["fxg_handler"],
            "level": "INFO",
            "propagate": False,
        },
        'settlement_create_logger': {
            "handler": ["settlement_create_handler"],
            "level": "INFO",
            "propagate": False,
        },
        'momo_stat_logger': {
            'handlers': ['momo_stat_log_handler'],
            'level': 'INFO',
            'propagate': False,
        },
        'gm_tracer.subscribe': {
            'handlers': ['tracer_handler'],
            'propagate': False,
            'level': 'INFO',
        },
        'trilateral_seckill_cache_logger': {
            'handlers': ['trilateral_seckill_cache_handler'],
            'level': 'INFO',
            'propagate': False,
        },
        'trilateral_user_bind_phone_logger': {
            'handlers': ['trilateral_user_bind_phone_handler'],
            'level': 'INFO',
            'propagate': False,
        },
    }
}


def config_gm_logging(log_dir, global_dict):
    pass

def GM_LOGGING():
    return {
        'request_info_extractor_class': 'mobile.logging.ShipMobileRequestInfoExtractor',
        'log': {
            'basedir': LOG_DIR,
            'prefix': 'ship',
            'buffered': False,
        }
    }


############################################### logging ###############################################

# PK_TOPICS 默认值
PK_TOPICS = {}

QINIU_ACCESS_KEY = "UPCOYIJkZOMcdd9FDzpBqYjzWUh55fBpVi3AhWpL"
QINIU_SECRET_KEY = "z5YvpDDSam_JE345Z8J_f3TufzelOW2VOGNoBl9e"


# 地图需求相关配置

CITY_COORDINATE = {
    u'北京': [116.46, 39.92],
    u'广州': [113.23, 23.16],
    u'上海': [121.48, 31.22],
    u'重庆': [106.54, 29.59],
    u'成都': [104.06, 30.67],
    u'武汉': [114.31, 30.52],
    u'深圳': [114.07, 22.62],
    u'郑州': [113.65, 34.76],
    u'西安': [108.95, 34.27],
    u'杭州': [120.19, 30.26],
    u'长沙': [113, 28.21],
    u'南京': [118.78, 32.04],
    u'南昌': [115.89, 28.68],
    u'沈阳': [123.38, 41.8],
    u'昆明': [102.73, 25.04],
    u'福州': [119.3, 26.08],
    u'青岛': [120.33, 36.07],
    u'南宁': [108.33, 22.84],
    u'天津': [117.2, 39.13],
    u'大连': [121.62, 38.92],
    u'石家庄': [114.48, 38.03],
    u'合肥': [117.27, 31.86],
    u'兰州': [103.73, 36.03],
    u'厦门': [118.1, 24.46],
    u'哈尔滨': [126.63, 45.75],
    u'苏州': [120.62, 31.32],
    u'长春': [125.35, 43.88],
    u'济南': [117, 36.65],
    u'温州': [120.65, 28.01],
    u'乌鲁木齐': [87.68, 43.77],
}

SALES_PERCENTAGE = [
          {
            'name': '北京',
            'value': '21.85'
          },
          {
            'name': '广州',
            'value': '9.28'
          },
          {
            'name': '上海',
            'value': '9.15'
          },
          {
            'name': '重庆',
            'value': '8.84'
          },
          {
            'name': '成都',
            'value': '8.07'
          },
          {
            'name': '武汉',
            'value': '6.19'
          },
          {
            'name': '深圳',
            'value': '5.78'
          },
          {
            'name': '郑州',
            'value': '5.72'
          },
          {
            'name': '西安',
            'value': '4.29'
          },
          {
            'name': '杭州',
            'value': '3.37'
          },
          {
            'name': '长沙',
            'value': '2.67'
          },
          {
            'name': '南京',
            'value': '2.40'
          },
          {
            'name': '南昌',
            'value': '1.82'
          },
          {
            'name': '沈阳',
            'value': '1.02'
          },
          {
            'name': '昆明',
            'value': '0.97'
          },
          {
            'name': '福州',
            'value': '0.82'
          },
          {
            'name': '青岛',
            'value': '0.80'
          },
          {
            'name': '南宁',
            'value': '0.77'
          },
          {
            'name': '天津',
            'value': '0.61'
          },
          {
            'name': '大连',
            'value': '0.55'
          },
          {
            'name': '石家庄',
            'value': '0.52'
          },
          {
            'name': '合肥',
            'value': '0.49'
          },
          {
            'name': '兰州',
            'value': '0.49'
          },
          {
            'name': '厦门',
            'value': '0.44'
          },
          {
            'name': '哈尔滨',
            'value': '0.43'
          },
          {
            'name': '苏州',
            'value': '0.39'
          },
          {
            'name': '长春',
            'value': '0.38'
          },
          {
            'name': '济南',
            'value': '0.37'
          },
          {
            'name': '温州',
            'value': '0.33'
          },
          {
            'name': '乌鲁木齐',
            'value': '0.32',
          }
]


RECOMMEND_SPECIAL = [
    {
        # 鼻综合
        'image_url': 'http://hera.s.igengmei.com/bodypart/2017/05/10/2cc1ed9f57',
        'service_id': 1382,
        'type': 0,
    },
    {
        # 双眼皮
        'image_url': 'http://hera.s.igengmei.com/bodypart/2017/05/10/3df76bf778',
        'service_id': 1383,
        'type': 0,
    },
    {
        # 祛眼袋
        'image_url': 'http://hera.s.igengmei.com/bodypart/2017/05/10/da4ba395e2',
        'service_id': 1393,
        'type': 0,
    },
    {
        # 双眼皮修复
        'image_url': 'http://hera.s.igengmei.com/bodypart/2017/05/10/7e9502d169',
        'service_id': 1399,
        'type': 0,
    },
    {
        # 自体脂肪填充
        'image_url': 'http://hera.s.igengmei.com/bodypart/2017/05/10/6f0e20d50e',
        'service_id': 1378,
        'type': 0,
    },
    {
        # 韩式半永久妆
        'image_url': 'http://hera.s.igengmei.com/bodypart/2017/05/10/3811090eb6',
        'service_id': 1401,
        'type': 0,
    },
    {
        # PRP自体脂肪填充面部
        'image_url': 'http://hera.s.igengmei.com/bodypart/2017/05/10/b8bdff1585',
        'service_id': 1396,
        'type': 0,
    },
    {
        # 玻尿酸注射
        'image_url': 'http://hera.s.igengmei.com/bodypart/2017/05/10/6860a3a087',
        'service_id': 1384,
        'type': 0,
    },
    {
        # 肉毒素除皱
        'image_url': 'http://hera.s.gmei.com/bodypart/2017/05/10/1443e6166a',
        'service_id': 1389,
        'type': 0,
    },
    {
        # 垫下巴
        'image_url': 'http://hera.s.igengmei.com/bodypart/2017/05/10/34e742bc97',
        'service_id': 1391,
        'type': 0,
    },
    {
        # 除皱
        'image_url': 'http://hera.s.igengmei.com/bodypart/2017/05/10/5d9413b6e2',
        'service_id': 1402,
        'type': 0,
    },
    {
        # 脱毛
        'image_url': 'http://hera.s.igengmei.com/bodypart/2017/05/10/b979bbcb34',
        'service_id': 1403,
        'type': 0,
    },
    {
        # 瘦脸
        'image_url': 'http://hera.s.igengmei.com/bodypart/2017/05/10/b3eb6dc9ee',
        'service_id': 1379,
        'type': 0,
    },
    {
        # 丰胸
        'image_url': 'http://hera.s.igengmei.com/bodypart/2017/05/10/9398dbaf0f',
        'service_id': 1380,
        'type': 0,
    },
    {
        # 隆鼻
        'image_url': 'http://hera.s.igengmei.com/bodypart/2017/05/10/89a393fca1',
        'service_id': 1381,
        'type': 0,
    },
    {
        # 吸脂
        'image_url': 'http://hera.s.igengmei.com/bodypart/2017/05/10/f8f8929462',
        'service_id': 1386,
        'type': 0,
    },
    {
        # 鹳骨
        'image_url': 'http://hera.s.igengmei.com/bodypart/2017/05/10/108964153c',
        'service_id': 1388,
        'type': 0,
    },
    {
        # 溶脂
        'image_url': 'http://hera.s.igengmei.com/bodypart/2017/05/10/49aec7d452',
        'service_id': 1390,
        'type': 0,
    },
    {
        # 牙齿矫正
        'image_url': 'http://hera.s.igengmei.com/bodypart/2017/05/10/c077a93c4e',
        'service_id': 1398,
        'type': 0,
    },
    {
        # 毛发移植
        'image_url': 'http://hera.s.igengmei.com/bodypart/2017/05/10/06746fd28c',
        'service_id': 1397,
        'type': 0,
    },
    {
        # 眼部整形
        'image_url': 'http://hera.s.igengmei.com/bodypart/2017/05/10/9d8c38abed',
        'service_id': 1395,
        'type': 0,
    },
    {
        # 补水保湿
        'image_url': 'http://hera.s.igengmei.com/bodypart/2017/05/10/a72456a347',
        'service_id': 1392,
        'type': 0,
    },
    {
        # 埋线提升
        'image_url': 'http://hera.s.igengmei.com/bodypart/2017/05/10/9f4e67418e',
        'service_id': 1385,
        'type': 0,
    },
    {
        # 手术减肥
        'image_url': 'http://hera.s.igengmei.com/bodypart/2017/05/10/d487aeb1dd',
        'service_id': 1394,
        'type': 0,
    },
    {
        # 隆鼻修复
        'image_url': 'http://hera.s.igengmei.com/bodypart/2017/05/10/364f09ccdb',
        'service_id': 1387,
        'type': 0,
    },
    {
        # 祛斑祛痣
        'image_url': 'http://hera.s.igengmei.com/bodypart/2017/05/10/b911178ab6',
        'service_id': 1400,
        'type': 0,
    },
    {
        # 美白嫩肤
        'image_url': 'http://hera.s.igengmei.com/bodypart/2017/05/10/cd55c8f2c6',
        'service_id': 1404,
        'type': 0,
    },
{
        'image_url': 'http://hera.s.igengmei.com/slide/2017/05/17/6fb7aa6612',
        'service_id': 1311,
        'type': 1,
    },
    {
        'image_url': 'http://hera.s.igengmei.com/slide/2017/05/17/95ed3b0d65',
        'service_id': 1319,
        'type': 1,
    },
    {
        'image_url': 'http://hera.s.igengmei.com/special/2017/05/17/0d38a70f3c',
        'service_id': 1313,
        'type': 1,
    },
    {
        'image_url': 'http://hera.s.igengmei.com/slide/2017/05/17/e8d57229ba',
        'service_id': 1307,
        'type': 1,
    },
    {
        'image_url': 'http://hera.s.igengmei.com/slide/2017/05/17/d9784a73de',
        'service_id': 1306,
        'type': 1,
    },
    {
        'image_url': 'http://hera.s.igengmei.com/slide/2017/05/17/c3651f38ca',
        'service_id': 1302,
        'type': 1,
    }
]


# 医院名同义词
HOSPITAL_SYNONYM = get_synonym()


API_HOST = 'http://backend.igengmei.com/'
SHIP_HOST = 'http://m.igengmei.com/'

# 分享购口令开关
FXG_SHOW_IN_SETTLEMENT = True


ICONS = [
    {
        'icon': 'http://hera.s.igengmei.com/2017/06/05/deaefdd5aa',
        'name': u'看日记',
        'jump_url': '/diary_list/',
    },
    {
        'icon': 'http://hera.s.igengmei.com/2017/06/05/00557227b6',
        'name': u'选美购',
        'jump_url': '/promotion_index/',
    },
    {
        'icon': 'http://hera.s.igengmei.com/2017/06/05/d92f750405',
        'name': u'找专家',
        'jump_url': '/expert_list/',
    },
    {
        'icon': 'http://hera.s.igengmei.com/2017/06/05/4586f60484',
        'name': u'查百科',
        'jump_url': '/wiki_list/',
    },
]

# Captcha 验证码图片样式(1:数字运算;2.四位字符或者数字)
CAPTCHA_STYLE = 2

SEARCH_NEW_SMART_RANK = ['3', '4']

SEARCH_SKU_GRAY = ['2', '0']

SEARCH_SMART_SERVICE = ['1']

FUN_CLAW_SPECIAL_ID = 2057
FUN_CLAW_IMG = 'http://hera.s.igengmei.com/activity/activity-crawl.jpg'

CATCH_CHANNEL_GIFT_IDS = [
    ('22_2136', 0.8, '10元无门槛优惠券'),
    ('22_2137', 0.8, '满1000减100元'),
    ('22_2138', 0.8, '满5000元500元'),
    ('22_2139', 0.8, '满10000减1000元'),
    ('5', 0.01, '机构免费项目  '),
    ('6', 0.002, '品牌化妆品 '),
]

# wechat pub connect prvmsg system
WECHATPUB_WHITE_LIST_FILE = os.path.join(BASE_DIR, 'mobile/views/wechatpub_prvmsg/files/tag_wiki.xlsx')
WECHATPUB_DOCTOR_INFO_XLSX = os.path.join(BASE_DIR, 'mobile/views/wechatpub_prvmsg/files/doctor_info.xlsx')
WECHATPUB_CITY_FILE = os.path.join(BASE_DIR, 'mobile/views/wechatpub_prvmsg/files/city.xlsx')

WECHATPUB_CLICKEVENT_EVENT_KEYS = {
    'V1_CLICK_GM_SGROUP_TRAINING': u'''欢迎加入「21天Keep fit健身计划」基础训练班，21天健身计划，帮你瘦成一道闪电！
立即加入：http://m.igengmei.com/wechat/3
立即加入：http://m.igengmei.com/wechat/3
立即加入：http://m.igengmei.com/wechat/3
高级健身私教视频教学，每天组队训练，搭配健身食谱。坚持21天，见证身材每一天的变化。''',

    'V1_CLICK_SERVICE_ACCOUNT_BTN': u'欢迎添加所长助理微信ID：gengmeizhuli',
}

# M站新人美券领取落地页配置
NEWBIE_COUPON_LANDING_PAGE = {
    'gift_id': 283,
    'business_channel_id': 78
}

# M站domain
SHIP_DOMAIN = '.igengmei.com'

# 金刀奖
DEFAULT_DOCTOR_PORTRAIT = 'http://hera.s.igengmei.com/2017/11/17/ba9df707a7'
DEFAULT_HOSPITAL_PORTRAIT = 'http://hera.s.igengmei.com/2017/11/17/036bf5046a'

MIP_DEFAULT_BANNER = "http://hera.s.igengmei.com/2018/04/21/cc0862879a"
MIP_DOWNLOAD_URL = "https://lnk0.com/doENx1"

# 问答内容为带html标签的格式
QA_RICH_TEXT_TYPE = (GRABBING_PLATFORM.ZHIHU, GRABBING_PLATFORM.WEIXIN, GRABBING_PLATFORM.WEIBO, GRABBING_PLATFORM.HERA)

SETTLEMENT_PAY_TIMEOUT = 30  # 待支付剩余时间，默认 30 min

# 手机号医生是否可见
PHONE_CAN_SEE_BY_DOCTOR = True

PAY_TOGGLE = {
    'alipay': True,
    'huabei': True,
    'wechat': True,
    'applepay': True,
    'xiaoying': True,
    'yinuo': True,
    'renmai': True,
    'maidan': True,
    'zhongan': True,
    'yirendai': True,
    'renmai_credit': True,
}

MOMO_STAT_LOG_TEST_FLAG = False  # 陌陌打点是否使用测试地址，正式环境为 False

GMTRACER_PARSER = 'ship.utils.setup_tracer'
# 采样率
TRACE_SAMPLE_RATE = 10.0


MESSAGE_ASK_CASE_IMAGES_LIST_FOR_MOMO_SECKILL = [  # 免费咨询页面案例，momo秒杀专用
    {
        "before": "http://hera.s.igengmei.com/2018/08/27/b6e003bd64",
        "after": "http://hera.s.igengmei.com/2018/08/27/97f14240e8",
    },
    {
        "before": "http://hera.s.igengmei.com/2018/08/27/d396ab0508",
        "after": "http://hera.s.igengmei.com/2018/08/27/4f3667bd4c",
    },
    {
        "before": "http://hera.s.igengmei.com/2018/08/27/87b174c469",
        "after": "http://hera.s.igengmei.com/2018/08/27/7b3221873e",
    },
]

MESSAGE_ASK_CASE_IMAGES_LIST = [  # 免费咨询页面案例
    {
        "before": "http://hera.s.igengmei.com/serviceactivity/2018/09/12/8f4c4d8f96",
        "after": "http://hera.s.igengmei.com/2018/08/27/97f14240e8",
    },
    {
        "before": "http://hera.s.igengmei.com/serviceactivity/2018/09/12/870ed8104d",
        "after": "http://hera.s.igengmei.com/2018/08/27/4f3667bd4c",
    },
    {
        "before": "http://hera.s.igengmei.com/serviceactivity/2018/09/12/b7edc1bc47",
        "after": "http://hera.s.igengmei.com/2018/08/27/7b3221873e",
    },
]


MESSAGE_ASK_CHANNEL_DICT = {  # 免费咨询，推广渠道
    "momo_seckill": TRANSFER_SOURCE.MOMO_SECKILL,
    "momo_ios": TRANSFER_SOURCE.MOMO_IOS,
    "bd_search": TRANSFER_SOURCE.BAIDU_SEARCH,
    "bd_special_goods": TRANSFER_SOURCE.BAIDU_SPECIAL_GOODS,
    "toutiao": TRANSFER_SOURCE.TOUTIAO,
    "others": TRANSFER_SOURCE.OTHERS,
}

# 微信小程序的原始Id
WECHAT_SMALL_USER_NAME = 'gh_566b862e19b3'
