# -*- coding: utf-8 -*-

import airflow
from airflow import DAG
from airflow.operators.python_operator import PythonOperator
from datetime import datetime, timedelta
import os,logging

logging.basicConfig(level=logging.INFO)
logger = logging.getLogger(__name__)

default_args = {
    'owner': 'tangxianggang',
    'depends_on_past': False,
    'start_date': datetime.now() - timedelta(minutes=2890),
    'retries': 2,
    'retry_delay': timedelta(seconds=5)
}

dag = DAG(
    dag_id='clear_tasks_container_logs',
    default_args=default_args,
    schedule_interval=timedelta(minutes=1445)
)

def clear_worker_logs():
    dt = datetime.now() - timedelta(minutes=1445)
    time_str = dt.strftime('%Y-%m-%d')
    cmd = 'rm -rf /opt/bitnami/airflow/logs/*/*/%s*' % (time_str)
    logger.info('exec cmd : ' + cmd)
    os.system(cmd)

task = PythonOperator(
    task_id='clear_worker_logs',
    python_callable=clear_worker_logs,
    dag=dag,
)

if __name__ == '__main__':
    dag.cli()
