# coding: utf-8
from datetime import timedelta, datetime
import calendar
from airflow import DAG
from airflow.operators.postgres_operator import PostgresOperator

from airflow.utils.dates import days_ago

default_args = {
    'owner': 'user',
    'depends_on_past': False,
    'start_date': days_ago(1),
    'email_on_failure': False,
    'email_on_retry': False,
    'retries': 1,
    'retry_delay': timedelta(minutes=5),
}

dag = DAG(
    'psql_auto_create_table_per_day',
    default_args=default_args,
    catchup=False,
    description='',
    schedule_interval='0 0 1 * * 0',  # 每月一号零点执行一次
)

# 获取当前日期
now_time = datetime.now()
# 获取当前时间的星期数和月数
week, days_num = calendar.monthrange(now_time.year, now_time.month)
# 获取本月的最后一天
end_day_in_mouth = now_time.replace(day=days_num)
# 获取下月的第一天
start_day = end_day_in_mouth + timedelta(days=1)
month = start_day.strftime('y%Ym%m')
# 获取下月的星期数和月数
week, days_num = calendar.monthrange(start_day.year, start_day.month)
# 获取下个月的最后一天
end_day = start_day + timedelta(days=(days_num-1))

end_str = str(end_day.date())
start_str = str(start_day.date())

sql1 = """
CREATE TABLE events_{month} partition of events  
    for values  FROM ('{start_str}') TO ('{end_str}');

""".format(month=month, start_str=start_str, end_str=end_str)
print(sql1)

sql2 = """
    ALTER TABLE events_{month} ADD CONSTRAINT pk_events_{month} PRIMARY KEY(id);
""".format(month=month)
print(sql2)

sql3 = """
    create index  idx_events_{month}_event_time  on  events_{month}(event_time);
""".format(month=month)
print(sql3)


t1 = PostgresOperator(
    task_id='psql_auto_create_table_per_day_task_01',
    postgres_conn_id='postgres-test',
    sql=sql1,
    dag=dag,
    database='ruler',
    pool='pricing_pool')

t2 = PostgresOperator(
    task_id='psql_auto_create_table_per_day_task_02',
    postgres_conn_id='postgres-test',
    sql=sql2,
    dag=dag,
    database='ruler',
    pool='pricing_pool')

t3 = PostgresOperator(
    task_id='psql_auto_create_table_per_day_task_03',
    postgres_conn_id='postgres-test',
    sql=sql3,
    dag=dag,
    database='ruler',
    pool='pricing_pool')

t1 >> t2
t2 >> t3
