from datetime import timedelta, datetime
from airflow import DAG
from airflow.operators.postgres_operator import PostgresOperator

from airflow.utils.dates import days_ago

default_args = {
    'owner': 'user',
    'depends_on_past': False,
    'start_date': days_ago(1),
    'email_on_failure': False,
    'email_on_retry': False,
    'retries': 1,
    'retry_delay': timedelta(minutes=5),
}

dag = DAG(
    'psql_auto_create_table_per_day',
    default_args=default_args,
    catchup=False,
    description='',
    schedule_interval='0 0 * * * 0',  # 每天零点执行一次
)

time_arg = datetime.now()
time_arg = time_arg.strftime('%Y%m%d')

# t1 =SSHOperator(
#                 task_id='diagnosis_check_start_consultation_per_2m_task_01',
#                 ssh_conn_id='bj-gm-prod-ubu-celery005-gmuser',
#                 command='source /srv/envs/diagnosis-celery/bin/activate  && '
#                         'cd /srv/apps/diagnosis-celery/ && '
#                         'python manage.py schedule_check_start_dispatch_ok',
#                 dag=dag,
#                 do_xcom_push=True
#             )

day = datetime.now()
day_str = day.strftime('%Y%m%d')

day_date_str = day.strftime('%Y-%m-%d')
next_day = day + datetime.timedelta(days=1)

next_day_date_str = next_day.strftime('%Y-%m-%d')
sql = """
CREATE TABLE events_{day_str} partition of events  
    for values  FROM ('{day_date_str}') TO ('{next_day_date_str}');

""".format(day_str=day_str, day_date_str=day_date_str, next_day_date_str=next_day_date_str)


t1 = PostgresOperator(
    task_id='psql_auto_create_table_per_day_task_01',
    postgres_conn_id='postgres-test',
    sql=sql,
    dag=dag,
    database='ruler',
    params={'period': '201905'},
    pool='pricing_pool')



