# -*- coding: utf-8 -*-
from datetime import timedelta, datetime
import calendar
from airflow import DAG
from airflow.operators.postgres_operator import PostgresOperator

from airflow.utils.dates import days_ago

default_args = {
    'owner': 'user',
    'depends_on_past': False,
    'start_date': days_ago(1),
    'email_on_failure': False,
    'email_on_retry': False,
    'retries': 1,
    'retry_delay': timedelta(minutes=5),
}

dag = DAG(
    'psql_reflush_per_month',
    default_args=default_args,
    catchup=False,
    description='',
    schedule_interval='10 3 7 * *',  # 每月7号11点10执行一次
)

sql1 = 'refresh materialized view concurrently materialized_doctor_view'


t1: PostgresOperator = PostgresOperator(
    task_id='psql_reflush_per_month_task_001',
    postgres_conn_id='postgres-test',
    sql=sql1,
    dag=dag,
    database='pims')
