# -*- coding: utf-8 -*-
from datetime import timedelta, datetime
import calendar
from airflow import DAG
from airflow.operators.postgres_operator import PostgresOperator

from airflow.utils.dates import days_ago

default_args = {
    'owner': 'user',
    'depends_on_past': False,
    'start_date': days_ago(1),
    'email_on_failure': False,
    'email_on_retry': False,
    'retries': 1,
    'retry_delay': timedelta(minutes=5),
}

dag = DAG(
    'psql_reflush_per_minute',
    default_args=default_args,
    catchup=False,
    description='',
    schedule_interval='* * * * *',  # 每分钟执行一次
)

sql1 = 'refresh materialized view concurrently materialized_doctor_view'
sql2 = 'refresh materialized view concurrently materialized_hospital_view'
sql3 = 'refresh materialized view concurrently materialized_plan_view'

t1: PostgresOperator = PostgresOperator(
    task_id='psql_reflush_per_minute_task_001',
    postgres_conn_id='postgres-test',
    sql=sql1,
    dag=dag,
    database='pims')

t2 = PostgresOperator(
    task_id='psql_reflush_per_minute_task_02',
    postgres_conn_id='postgres-test',
    sql=sql2,
    dag=dag,
    database='pims')

t3 = PostgresOperator(
    task_id='psql_reflush_per_minute_task_03',
    postgres_conn_id='postgres-test',
    sql=sql3,
    dag=dag,
    database='pims')

t1 >> t2
t2 >> t3
