# coding=utf-8
from __future__ import unicode_literals, print_function, absolute_import

import csv
from test_backend.testing import TestCaseBase
from test_backend.connectMysql import ConnectMysql
from test_backend.run_summary_data import RunSummary
import json
from test_backend.testing import TestCaseBase
from test_backend.collect import Collect
from test_backend.log_data import LogData
from test_backend.device_data import Device
from test_backend.delete_mars_data import DeleteData
import pandas as pd
import numpy as np
import datetime
import time
import random
from test_backend.settings import Settings


class Calculation(TestCaseBase):
    #测试event
    log_data = []
    mysql_data = []

    #1、根据预期制造数据
    def create_log_data(self, type, params, device_data, timenow=None):
        paramList = LogData().getLogeData(type, params, device_data, timenow)
        data = Collect.postDatas(paramList)
        #记录到 /data/logstash/app_input/maidian

    def get_mysql_data(self, sqlStr):
        mysql_data = ConnectMysql.getDatas(sqlStr)
        return mysql_data

    def create_data(self):
        i = 0
        home_view_time = 10
        device_data = Device().getDeviceData()

        while i < home_view_time:
            type = "main_click_tab" #
            params = {"tab":"welfare"}#{"tag_id":1,"from":"diagnosis","type":"string","business_id":"string","action":"string"}
            self.log_data = self.create_log_data(type, params, device_data)
            print('运行'+ str(type) + str( i+ 1) + '次')
            i = i + 1

        #或者造mysql数据
        #dbname = Settings.Backend.DBmars+'.statistic_eventsummary'
        #DeleteData().delete_data(dbname, '2016-03-02')

    #2、linlin，跑脚本
    def run_summary_data(self):
        commend = '--master local[1] release.jar ' \
                  '--run-task X2_MaidianSummary -A gmLogName=maidian -A taskProcessingDate=2016-03-03'.split()
        RunSummary.run_summary_data(commend)


    def compareList(self, listA, listB):
        if len(listA) != len(listB):
            print('长度不等')
            return False
        l1 = sorted(listA)
        l2 = sorted(listB)
        #print(l1)
        for v1, v2 in zip(l1, l2):
            if v1 != v2:
                print('数据不等')
                return False
        return True

    #3、公式比对预期值
    def comparison_data(self):
        actual_value = self.get_mysql_data("select d.date, d.eventdesc_id, d.page_view, d.user_view, d.device_view from "
                                           +Settings.Backend.DBmars+".statistic_eventsummary d WHERE d.date = '2016-03-03'")
        #print(actual_value)
        #根据具体情况处理数据，假设处理完数据如下
        expected_value = []
        assert self.compareList(expected_value, actual_value)


    def test_calculation(self):
        #case：造数据部分
        self.create_data()

        #case：运行汇总数据脚本
        self.run_summary_data()

        #case：数据进行比对
        self.comparison_data()




