# coding=utf-8
from __future__ import unicode_literals, print_function, absolute_import

from test_backend.connectMysql import ConnectMysql
from test_backend.run_summary_data import RunSummary
import json
from test_backend.testing import TestCaseBase
from test_backend.collect import Collect
from test_backend.log_data import LogData
from test_backend.device_data import Device
import datetime
import time
import random
from test_backend.settings import Settings
from test_backend.app_sessionId import AppSessionId


class Calculation(TestCaseBase):
    #测试event
    log_data = []
    mysql_data = []
    deviceId = 0#真正的设备型号id

    #1、根据预期制造数据
    def create_log_data(self, type, params, device_data, timenow=None, app_session_id=None):
        paramList = LogData().getLogeData(type, params, device_data, timenow, app_session_id)
        data = Collect.postDatas(paramList)
        #记录到 /data/logstash/app_input/maidian

    def get_mysql_data(self, sqlStr):
        mysql_data = ConnectMysql.getDatas(sqlStr)
        return mysql_data

    def create_data(self):
        self.deviceId = AppSessionId().getAppSessionId()
        device_r = [{"APP": {"is_activation": True},
                     "SYS": {"cl_id": str(self.deviceId), "channel": "Lenovo"},
                     "TIME": datetime.datetime.fromtimestamp(time.time()).strftime("%Y-%m-%dT%H:%M:%S+08:00")}]
        Collect().write_gaia_log(device_r)

        #或者造mysql数据
        #dbname = Settings.Backend.DBmars+'.statistic_eventsummary'
        #DeleteData().delete_data(dbname, '2016-03-02')

    #2、linlin，跑脚本
    def run_summary_data(self):
        commend = '--master local[1] release.jar ' \
                  '--run-task X2_DeviceAndUserStat -A taskProcessingDate=2016-03-04'.split()
        RunSummary.run_summary_data(commend)


    def compareList(self, listA, listB):
        if len(listA) != len(listB):
            print('长度不等')
            return False
        l1 = sorted(listA)
        l2 = sorted(listB)

        #print(l1)
        for v1, v2 in zip(l1, l2):
            if v1 != v2:
                print('数据不等')
                return False
        return True

    #3、公式比对预期值
    def comparison_data(self):
        actual_value = self.get_mysql_data("select d.device_id, d.new_date, d.channel from "
                                           +Settings.Backend.DBmars+".statistic_device d "
                                                                    "WHERE d.new_date = '2016-03-04' and d.device_id='"+str(self.deviceId)+"'")
        print(actual_value)
        #根据具体情况处理数据，假设处理完数据如下
        expected_value = [(self.deviceId, datetime.date(2016, 3, 4), "Lenovo")]
        assert self.compareList(expected_value, actual_value)


    def test_calculation(self):
        #case：造数据部分
        self.create_data()

        #case：运行汇总数据脚本
        self.run_summary_data()

        #case：数据进行比对
        self.comparison_data()




