# coding=utf-8
from __future__ import unicode_literals, print_function, absolute_import

import csv
from test_backend.testing import TestCaseBase
from test_backend.connectMysql import ConnectMysql
import json
from test_backend.testing import TestCaseBase
from test_backend.collect import Collect
from test_backend.log_data import LogData
from test_backend.device_data import Device
import pandas as pd
import numpy as np
import datetime
import time
import random
from test_backend.settings import Settings

class Calculation(TestCaseBase):
    #以首页轮播Banner为例
    log_data = []
    mysql_data = []
    expected_value = {'date': '1', 'doctor_name': '2', 'new_convos': '3', 'noreply_convos': '4'}
    #涉及公式    点击率	100%*该banner点击次数/首页PV


    #1、根据预期制造数据
    def create_log_data(self, type, params, device_data):
        paramList = LogData().getLogeData(type, params, device_data)
        data = Collect.postDatas(paramList)
        #记录到 /data/logstash/app_input/maidian

    def get_mysql_data(self, sqlStr):
        mysql_data = ConnectMysql.getDatas(sqlStr)
        return mysql_data

    def create_data(self):
        i = 0
        banner_click_time = 2
        home_view_time = 4
        device_data = Device().getDeviceData(3)

        while i < home_view_time:
            #首页PV
            type = "page_view"
            #business_id：doctor, service, diary, topic, zone
            inTime = time.time()
            outTime = time.time() + 5
            params = {"page_name": "home", "business_id": '', "in": inTime, "out": outTime, "fake": 0}
            self.log_data = self.create_log_data(type, params, device_data)
            print('运行'+ str(type) + str( i+ 1) + '次')
            if i < banner_click_time:
                #该banner点击次数
                type = "on_click_banner"
                banner_idList = [14, 77]
                for id in  banner_idList:
                    params = {"from": "home_banner", "banner_id": id}
                    self.log_data = self.create_log_data(type, params, device_data)
            i = i + 1

            #或者造mysql数据

    #2、linlin，跑脚本
    def run_summary_data(self):
        time.sleep(20)
        pass

    def compareList(self, listA, listB):
        if len(listA) != len(listB):
            return False
        l1 = sorted(listA)
        l2 = sorted(listB)
        for v1, v2 in zip(l1, l2):
            if v1 != v2:
                return False
        return True

    #3、公式比对预期值
    def comparison_data(self):
        #单列用户
        expected_value = self.get_mysql_data("SELECT dv.stat_date, d.name, dv.new_pm_user_num, dv.noreply_pm_user_num "
                                             " from "+Settings.Backend.DBzhengxing_test+".statistic_doctorview dv, zhengxing_test.api_doctor  d "
                                             "where dv.doctor_id = d.id and dv.stat_date = '2016-02-22' and "
                                             "dv.doctor_id in(SELECT dd.doctor_id "
                                             " from "+Settings.Backend.DBmars+".statistic_doctordetail dd "
                                             "where dd.stat_type=1)")
        actual_value = self.get_mysql_data("SELECT dd.date, dd.doctor_name, dd.new_convos, dd.noreply_convos "
                                           " from "+Settings.Backend.DBmars+".statistic_doctordetail dd "
                                           "where dd.date = '2016-02-22'  and "
                                           "dd.doctor_id in(SELECT dd.doctor_id "
                                           " from "+Settings.Backend.DBmars+".statistic_doctordetail dd "
                                           "where dd.stat_type=1)")
        assert self.compareList(expected_value, actual_value)



        #常例用户
        expected_value = self.get_mysql_data("SELECT dv.stat_date, d.name, dv.new_pm_user_num, dv.noreply_pm_user_num "
                                             " from "+Settings.Backend.DBzhengxing_test+".statistic_doctorview dv, "
                                                                                        "zhengxing_test.api_doctor  d "
                                             "where dv.doctor_id = d.id and dv.stat_date = '2016-02-22' "
                                             "and (dv.new_pm_user_num>0 OR dv.noreply_pm_user_num>0)")
        actual_value = self.get_mysql_data("SELECT dd.date, dd.doctor_name, dd.new_convos, dd.noreply_convos "
                                           " from "+Settings.Backend.DBmars+".statistic_doctordetail dd "
                                           "where dd.date = '2016-02-22'  and "
                                           "dd.doctor_id in(SELECT dd.doctor_id "
                                           " from "+Settings.Backend.DBmars+".statistic_doctordetail dd "
                                           "where dd.stat_type=0)")
        assert self.compareList(expected_value, actual_value)




    def test_calculation(self):
        #case：造数据部分
        #self.create_data()

        #case：运行汇总数据脚本
        self.run_summary_data()

        #case：数据进行比对
        self.comparison_data()




