# coding=utf-8
from __future__ import unicode_literals, print_function, absolute_import

import csv
from test_backend.testing import TestCaseBase
from test_backend.connectMysql import ConnectMysql
from test_backend.run_summary_data import RunSummary
import json
from test_backend.testing import TestCaseBase
from test_backend.collect import Collect
from test_backend.log_data import LogData
from test_backend.device_data import Device
from test_backend.delete_mars_data import DeleteData
import pandas as pd
import numpy as np
import datetime
import time
import random

from test_backend.settings import Settings


class Calculation(TestCaseBase):
    #测试page_view：
    log_data = []
    mysql_data = []

    #1、根据预期制造数据
    def create_log_data(self, type, params, device_data, timenow=None):
        paramList = LogData().getLogeData(type, params, device_data, timenow)
        data = Collect.postDatas(paramList)
        #记录到 /data/logstash/app_input/maidian

    def get_mysql_data(self, sqlStr):
        mysql_data = ConnectMysql.getDatas(sqlStr)
        return mysql_data

    def create_data(self):
        i = 0
        home_view_time = 10
        device_data = Device().getDeviceData()

        while i < home_view_time:
            type = "page_view"
            #business_id：doctor, service, diary, topic, zone
            inTime = time.time()
            outTime = time.time() + 4.5
            params = {"page_name": "event_promotion_coupon", "business_id": '', "in": inTime, "out": outTime, "fake": 0, "referrer": "welfare_home"}
            self.log_data = self.create_log_data(type, params, device_data)
            print('运行'+ str(type) + str( i+ 1) + '次')
            i = i + 1

        #或者造mysql数据
        dbname = Settings.Backend.DBmars+'.statistic_pagesummary'
        DeleteData().delete_data(dbname, '2016-02-29')

    #2、linlin，跑脚本
    def run_summary_data(self):
        commend = '--master local[1] release.jar --run-task X2_AppPageSummary -A ' \
                  'gmLogName=maidian -A taskProcessingDate=2016-02-29'.split()
        RunSummary.run_summary_data(commend)

    def compareList(self, listA, listB):
        if len(listA) != len(listB):
            return False
        l1 = sorted(listA)
        l2 = sorted(listB)
        for v1, v2 in zip(l1, l2):
            if v1 != v2:
                return False
        return True

    #3、公式比对预期值
    def comparison_data(self):
        actual_value = self.get_mysql_data("select d.date, d.event, d.event_type, d.page_view, d.user_view,d.device_view, d.duration from "
                                           +Settings.Backend.DBmars+".statistic_pagesummary d WHERE d.date = '2016-02-29'")
        #根据具体情况处理数据，假设处理完数据如下
        expected_value = [(datetime.date(2016, 2, 29), 'home', 'page', 20L, 2L, 2L, 100L),
                          (datetime.date(2016, 2, 29), 'home', 'click', 10L, 1L, 1L, 50L),
                          (datetime.date(2016, 2, 29), 'register', 'page', 10L, 1L, 1L, 50L),
                          (datetime.date(2016, 2, 29), 'login_password', 'click', 11L, 2L, 2L, 55L),
                          (datetime.date(2016, 2, 29), 'diary_comment_list', 'click', 10L, 1L, 1L, 50L),
                          (datetime.date(2016, 2, 29), 'csc_name', 'click', 10L, 1L, 1L, 50L),
                          (datetime.date(2016, 2, 29), 'activity_promotion', 'page', 20L, 2L, 2L, 100L),
                          (datetime.date(2016, 2, 29), 'event_promotion_coupon', 'page', 10L, 1L, 1L, 45)]
        assert self.compareList(expected_value, actual_value)


    def test_calculation(self):
        #case：造数据部分
        self.create_data()

        #case：运行汇总数据脚本
        self.run_summary_data()
        time.sleep(10)

        #case：数据进行比对
        self.comparison_data()




