# -*- coding: UTF-8 -*-
# !/usr/bin/env python

from __future__ import unicode_literals, absolute_import, print_function
from gm_rpcd.all import bind
import logging
import traceback
import json
from search.utils.topic import TopicUtils
from libs.es import ESPerform
from libs.cache import redis_client
from search.utils.common import *

from gm_rpcd.all import bind
import functools
import logging
import traceback
from libs.es import ESPerform

logger = logging.getLogger(__name__)

MAX_LOAD = 100
GROUP_SIZE = 10


@bind('doris/search/query_contrast_similar')
def contrast_similar(user_id, offset=0, size=10):
    try:
        if isinstance(user_id, int):
            contrast_topic_id_list = get_all_topic_id_list(user_id, offset, size)
            return {"contrast_user_id_list": contrast_topic_id_list}

    except:

        logging.error("catch exception,err_msg:%s" % traceback.format_exc())
        return {"contrast_user_id_list": []}


def get_all_topic_id_list(user_id, offset, size):
    try:
        if user_id:
            redis_key = "physical:user_similar:participant_user_id:" + str(user_id)
            redis_field_val_list = redis_client.get(redis_key)
            have_read_topic_id_list = json.loads(redis_field_val_list) if redis_field_val_list else []
            read_topic_id_list = list()
            if len(have_read_topic_id_list) > 0:
                for i in have_read_topic_id_list:
                    read_topic_id_list.append(i.get("contrast_user_id"))
                q = {
                    "query": {
                        "function_score": {
                            "query": {
                                "bool": {
                                    "must": [{
                                        "term": {
                                            "is_online": True
                                        }
                                    }, {
                                        "term": {
                                            "is_deleted": False
                                        }
                                    }],
                                    "should": {
                                        "match": {
                                            "participant_user_id": read_topic_id_list
                                        }
                                    },
                                    "minimum_should_match": 1
                                }
                            }

                        }

                    }

                }

                logging.info('contrast_similar,as q:%s' % str(q).encode('utf-8'))

                result_dict = ESPerform.get_search_results(ESPerform.get_cli(), sub_index_name="topic",
                                                           query_body=q,
                                                           offset=offset, size=size)
                contrast_topic_ids = []

                if result_dict['hits']["total"] > 0:

                    res_hit = result_dict['hits']["hits"]

                    for item in res_hit:
                        topic_id = item['_source']['id']
                        contrast_topic_ids.append(topic_id)

                    logging.info('contrast_similar_topic_id:%s' % contrast_topic_ids)

                return {"contrast_user_id_list": contrast_topic_ids}


    except:

        logging.error("catch exception,err_msg:%s" % traceback.format_exc())
        return {"contrast_user_id_list": []}
