#!/usr/bin/env python
# -*- coding: utf-8 -*-

from __future__ import unicode_literals, absolute_import, print_function
from gm_rpcd.all import bind
import logging
import traceback
import json
from search.utils.topic import TopicUtils
from libs.es import ESPerform
from libs.cache import redis_client
from search.utils.common import *
from libs.es import ESPerform

user_id = 241407653
query_type = 1


def get_home_recommend_topic_ids(user_id, device_id, offset, size, query=None, query_type=TopicPageType.HOME_RECOMMEND):
    try:
        # hget
        # physical:home_recommend:user_id:241407653:query_type:1
        # 0
        import pdb
        pdb.set_trace()

        if query is None:
            if user_id == -1:
                redis_key = "physical:home_recommend" + ":user_id:" + str(
                    user_id) + ":device_id:" + device_id + ":query_type:" + str(query_type)
            else:
                redis_key = "physical:home_recommend" + ":user_id:" + str(user_id) + ":query_type:" + str(query_type)
        else:
            if user_id == -1:
                redis_key = "physical:home_query" + ":user_id:" + str(
                    user_id) + ":device_id:" + device_id + ":query:" + str(query) + ":query_type:" + str(query_type)
            else:
                redis_key = "physical:home_query" + ":user_id:" + str(user_id) + ":query:" + str(
                    query) + ":query_type:" + str(query_type)

        redis_field_list = [b'last_offset_num', b'unread_topic_id']
        '''
        1) "unread_topic_id"
        2) "{}"
        3) "last_offset_num"
        4) "10"
        5) "0"
        6) "[18925, 537727, 22538, 537772, 2019, 15686, 257, 97, 700, 1368]"
        '''
        '''
         1) "unread_topic_id"
         2) "{}"
         3) "last_offset_num"
         4) "30"
         5) "10"
         6) "[2562, 6896, 2167, 537720, 6180, 257, 2027, 1349, 1368, 1380]"
         7) "20"
         8) "[537711, 291, 5895, 287, 1291, 1265, 1331, 15533, 15478, 6021]"
         9) "0"
        10) "[537763, 15403, 18925, 22538, 537772, 2398, 6917, 2479, 15702, 1317]"
        '''
        for page_id in range(0, offset, size):
            redis_field_list.append(str(page_id))
        redis_field_val_list = redis_client.hmget(redis_key, redis_field_list)
        # 获取上次的请求的offset
        last_offset_num = int(redis_field_val_list[0]) if redis_field_val_list[0] else -1
        recommend_topic_ids = []
        # 根据user_id 和offset获取帖子ID
        topic_id_dict = TopicUtils.get_recommend_topic_ids(user_id, offset, size * size, query, query_type=query_type)
        have_read_group_id_set = set()  # 已经读过的帖子的组ID
        unread_topic_id_dict = dict()
        have_read_topic_id_set = set()
        # 判断这个用户如果看过帖子，先获取他看过的帖子
        # 判断unread_topic_id 是否有值
        if redis_field_val_list[1] and offset > 0:
            # 如果有值  代表用户看过#如果用户请求的offset 和last_offset_num相等
            if (user_id > 0 and offset == last_offset_num) or user_id == -1:
                # 获取redis中用户未读的帖子ID
                ori_unread_topic_id_dict = json.loads(redis_field_val_list[1])
                # 如果有值
                if len(ori_unread_topic_id_dict) > 0:
                    # 从新获取的帖子中加上未读的帖子
                    topic_id_dict.update(ori_unread_topic_id_dict)
                # 获取用户之前看过的帖子
                for have_read_item in redis_field_val_list[2:]:
                    if have_read_item:
                        # 把看过的帖子放到一起
                        have_read_topic_id_set = have_read_topic_id_set.union(json.loads(have_read_item))

        # 当前页小组数量
        cur_page_group_num = 0
        # 当前页用户数量
        cur_page_user_num = 0
        ##从新获取的帖子中加上未读的帖子
        for topic_id in topic_id_dict:
            # 如果新的帖子所在的组在已读的组的里边
            if topic_id_dict[topic_id] in have_read_group_id_set:
                # 把新帖子对应的帖子ID和组ID放到unread_topic_id_dict
                unread_topic_id_dict[topic_id] = topic_id_dict[topic_id]
            else:
                # 如果新帖子不在have_read_topic_id_set
                if topic_id not in have_read_topic_id_set:
                    # 所在组 cur_page_group_num     cur_page_group_num < (size * 0.9)
                    if isinstance(topic_id_dict[topic_id], int) and topic_id_dict[topic_id] > 0 and cur_page_group_num < (size * 0.9):
                        have_read_group_id_set.add(topic_id_dict[topic_id])
                        have_read_topic_id_set.add(topic_id)
                        cur_page_group_num += 1
                        recommend_topic_ids.append(topic_id) #要推荐的帖子ID
                    elif topic_id_dict[topic_id] and cur_page_user_num < (size * 0.1):
                        cur_page_user_num += 1
                        recommend_topic_ids.append(topic_id)
                    else:
                        unread_topic_id_dict[topic_id] = topic_id_dict[topic_id]

                    if len(recommend_topic_ids) >= size:
                        break

        offi_unread_topic_id_dict = dict()
        if len(recommend_topic_ids) < size and len(unread_topic_id_dict) > 0:
            for unread_topic_id in unread_topic_id_dict:
                if len(recommend_topic_ids) < size:
                    recommend_topic_ids.append(unread_topic_id)
                else:
                    offi_unread_topic_id_dict[unread_topic_id] = unread_topic_id_dict[unread_topic_id]

        redis_dict = {
            "unread_topic_id": json.dumps(offi_unread_topic_id_dict),
            "last_offset_num": offset + size,
            offset: json.dumps(recommend_topic_ids)
        }
        redis_client.hmset(redis_key, redis_dict)
        # 每个session key保存15分钟
        redis_client.expire(redis_key, 15 * 60 * 60)

        return recommend_topic_ids
    except:
        logging.error("catch exception,err_msg:%s" % traceback.format_exc())
        return []
