import datetime
from django.db import models
import logging
import traceback

from .tag import Tag
from .topic import Topic


class CommodityProduct(models.Model):
    """画报关注"""

    class Meta:
        verbose_name = u"商品"
        app_label = "commodity"
        db_table = "commodity_product"

    id = models.IntegerField(verbose_name=u'商品ID', primary_key=True)
    create_time = models.DateTimeField(verbose_name=u'创建时间', default=datetime.datetime.fromtimestamp(0))
    update_time = models.DateTimeField(verbose_name=u'更新时间', default=datetime.datetime.fromtimestamp(0))
    is_online = models.BooleanField(verbose_name=u'是否上线')
    is_deleted = models.BooleanField(verbose_name=u'是否删除')
    cn_name = models.CharField(verbose_name=u'商品名称', max_length=64)
    en_name = models.CharField(verbose_name=u'商品原名', max_length=64, default="")
    alias = models.CharField(verbose_name=u'别名', max_length=64)
    image = models.CharField(verbose_name=u'图片', max_length=120)
    description = models.CharField(verbose_name=u'商品描述', max_length=200)
    comment_nums = models.IntegerField(verbose_name=u'评论数', max_length=11)
    price = models.IntegerField(verbose_name="价格", max_length=11)

    def get_brand_name(self):
        try:
            brand_id = CommodityProductBrand.objects.filter(product_id=self.id, is_deleted=False).values_list(
                "brand_id", flat=True)
            result_name = CommodityBrand.objects.filter(id=brand_id, is_online=True, is_deleted=False).values("cn_name",
                                                                                                              "en_name",
                                                                                                              "alias").first()
            return result_name

        except:
            logging.error("catch exception,err_msg:%s" % traceback.format_exc())
            return []

    def get_category_en_name(self):
        try:
            category_id = CommodityProductCategory.objects.filter(product_id=self.id, is_deleted=False).values_list(
                "category_id", flat=True)
            result_name = CommodityCategory.objects.filter(id=category_id, is_online=True,
                                                           is_deleted=False).values_list("cn_name", flat=True)

            return list(result_name)

        except:
            logging.error("catch exception,err_msg:%s" % traceback.format_exc())
            return ""

    def get_effect_cn_name(self):
        try:
            effect_id = CommodityProductEffect.objects.filter(product_id=self.id, is_deleted=False).values_list(
                "effect_id", flat=True)
            result_name = CommodityEffect.objects.filter(id=effect_id, is_deleted=False).values_list("cn_name",
                                                                                                     flat=True)

            return list(result_name)

        except:
            logging.error("catch exception,err_msg:%s" % traceback.format_exc())
            return ""


class CommodityBrand(models.Model):
    """品牌"""

    class Meta:
        verbose_name = u'品牌'
        app_label = 'commodity'
        db_table = 'commodity_brand'

    id = models.IntegerField(verbose_name=u'品牌ID', primary_key=True)
    create_time = models.DateTimeField(verbose_name=u'创建时间', default=datetime.datetime.fromtimestamp(0))
    update_time = models.DateTimeField(verbose_name=u'更新时间', default=datetime.datetime.fromtimestamp(0))
    is_online = models.BooleanField(verbose_name=u'是否上线')
    is_deleted = models.BooleanField(verbose_name=u'是否删除')
    cn_name = models.CharField(verbose_name=u'品牌名称', max_length=64)
    en_name = models.CharField(verbose_name=u'品牌原名', max_length=64)
    alias = models.CharField(verbose_name=u'别名', max_length=64)
    description = models.CharField(verbose_name=u'品牌描述', max_length=200)


class CommodityCategory(models.Model):
    """类目"""

    class Meta:
        verbose_name = u'类目'
        app_label = 'commodity'
        db_table = 'commodity_category'

    id = models.IntegerField(verbose_name=u'品牌ID', primary_key=True)
    create_time = models.DateTimeField(verbose_name=u'创建时间', default=datetime.datetime.fromtimestamp(0))
    update_time = models.DateTimeField(verbose_name=u'更新时间', default=datetime.datetime.fromtimestamp(0))
    is_online = models.BooleanField(verbose_name=u'是否上线')
    is_deleted = models.BooleanField(verbose_name=u'是否删除')
    cn_name = models.CharField(verbose_name=u'品牌名称', max_length=64)


class CommodityEffect(models.Model):
    """功效"""

    class Meta:
        verbose_name = u'功效'
        app_label = 'commodity'
        db_table = 'commodity_effect'

    id = models.IntegerField(verbose_name=u'品牌ID', primary_key=True)
    create_time = models.DateTimeField(verbose_name=u'创建时间', default=datetime.datetime.fromtimestamp(0))
    update_time = models.DateTimeField(verbose_name=u'更新时间', default=datetime.datetime.fromtimestamp(0))
    is_deleted = models.BooleanField(verbose_name=u'是否删除')
    cn_name = models.CharField(verbose_name=u'品牌名称', max_length=64)


class CommodityProductBrand(models.Model):
    """商品品牌关系"""

    class Meta:
        verbose_name = u'商品品牌关系'
        app_label = 'commodity'
        db_table = 'commodity_productbrand'

    id = models.IntegerField(verbose_name=u'ID', primary_key=True)
    product_id = models.BigIntegerField(verbose_name=u'商品ID')
    brand_id = models.BigIntegerField(verbose_name=u'品牌ID')
    is_deleted = models.BooleanField(verbose_name=u'是否删除')


class CommodityProductCategory(models.Model):
    """画报关注"""

    class Meta:
        verbose_name = u"画报"
        app_label = "commodity"
        db_table = "commodity_productcategory"

    id = models.IntegerField(verbose_name=u'关注ID', primary_key=True)
    is_deleted = models.BooleanField(verbose_name=u'是否删除')
    product_id = models.BigIntegerField(verbose_name=u'商品ID')
    category_id = models.BigIntegerField(verbose_name=u'分类ID')


class CommodityProductEffect(models.Model):
    """画报关注标签"""

    class Meta:
        verbose_name = u"画报标签"
        app_label = "commodity"
        db_table = "commodity_producteffect"

    id = models.IntegerField(verbose_name=u'关注ID', primary_key=True)
    is_deleted = models.BooleanField(verbose_name=u'是否删除')
    product_id = models.BigIntegerField(verbose_name=u'商品ID')
    effect_id = models.BigIntegerField(verbose_name=u'功效ID')
