#!/usr/bin/env python
# -*- coding: utf-8 -*-

from gm_rpcd.all import bind
import logging
import traceback
from search.utils.topic import TopicUtils


@bind("physical/search/home_recommend")
def home_recommend(user_id=-1,offset=0,size=10):
    """
    :remark:首页推荐，目前只推荐日记
    :return:
    """
    try:
        # 马甲账号集合
        vest_account_list = list()

        result_dict = TopicUtils.get_related_user_info(user_id,offset,size)
        if len(result_dict["hits"]) == 0:
            logging.error("Not find user_id:%d in es!" % int(user_id))
            return {"recommend_topic_ids":[]}

        attention_user_info_list = result_dict["hits"][0]["attention_user_id_list"]
        (attention_chinese_user_id_list, attention_japan_user_id_list, attention_korea_user_id_list) = TopicUtils.analyze_related_user_id_list(related_user_id_list=attention_user_info_list)

        pick_user_info_list = result_dict["hits"][0]["pick_user_id_list"]
        (pick_chinese_user_id_list, pick_japan_user_id_list, pick_korea_user_id_list) = TopicUtils.analyze_related_user_id_list(pick_user_info_list)

        same_group_user_info_list = result_dict["hits"][0]["same_group_user_id_list"]
        (same_group_chinese_user_id_list, same_group_japan_user_id_list, same_group_korea_user_id_list) = TopicUtils.analyze_related_user_id_list(same_group_user_info_list)

        q = dict()
        q["filter"] = {
            "range":{"content_level":{"gte":3,"lte":5}}
        }
        query_function_score = dict()
        functions = [
            {
                "filter":{"match":{"user_id":attention_chinese_user_id_list}},
                "weight": 5,
            },
            {
                "filter":{"match":{"user_id":pick_chinese_user_id_list}},
                "weight":3
            },
            {
                "filter": {"match": {"user_id": same_group_chinese_user_id_list}},
                "weight": 2
            },
            {
                "filter": {"match": {"user_id": vest_account_list}},
                "weight": 0.5
            },
            {
                "filter":{"match":{"content_level":5}},
                "weight":5
            },
            {
                "filter":{"match":{"content_level":4}},
                "weight":3
            },
            {
                "filter":{"match":{"content_level":3}},
                "weight":2
            }
        ]




    except:
        logging.error("catch exception,err_msg:%s" % traceback.format_exc())
        return {"recommend_topic_ids": []}

