#!/usr/bin/env python
# -*- coding: utf-8 -*-

from django.conf import settings
from pytz import timezone
from datetime import datetime


def tzlc(dt, truncate_to_sec=True):
    if dt is None:
        return None
    if truncate_to_sec:
        dt = dt.replace(microsecond=0)
    return timezone(settings.TIME_ZONE).localize(dt)