# -*- coding: UTF-8 -*-
from gm_rpcd.all import bind
from libs.algorithms import variousness, region_division
from libs.debug import pretty_json
from libs.es import es_query
import functools
import logging
import traceback
import datetime

logger = logging.getLogger(__name__)

MAX_LOAD = 100
GROUP_SIZE = 10
variousness_per_10 = functools.partial(variousness, variety_size=GROUP_SIZE)


@bind('doris/search/query_contrast_similar')
def query_contrast_similar(query, offset=0, size=10):
    size = min(size, MAX_LOAD)

    try:
        assert (query is not None and len(query) > 0)

        multi_fields = {
            'user_id': 100,
        }
        query_fields = ['^'.join((k, str(v))) for (k, v) in multi_fields.items()]

        multi_match = {
            'query': query,
            'type': 'cross_fields',
            'operator': 'and',
            'fields': query_fields,
        }
        q = {
            "query": {
                "function_score": {
                    "query": {
                        "bool": {
                            "should": [{"multi_match": multi_match}],
                            "must": [
                                {"term": {
                                    "is_online": True}
                                },
                                {"term": {
                                    "is_deleted": False}
                                }
                            ],

                            "minimum_should_match": 1
                        },

                    }

                }
            },
            "sort": [{"similarity": "desc"}],
            "size": size
        }

        logging.info('test query es :%s' % str(q).encode('utf-8'))

        res = es_query('contrast_similar', q, offset, size)

        logging.info(('res contrast_similar :%s' % str(res)))

        wiki_hot_recommends = []

        logging.info("q:%s" % q)

        res_hit = res["hits"]["hits"]

        for item in res_hit:

            if '_source' in item:
                wiki_name = item['_source']['contrast_user_id_list']

        logging.info('contrast_user_id_list res:%s' % wiki_name)

        return {"wiki_hot_recommends": wiki_name}

    except:

        logging.error("catch exception, query_sku:%s" % traceback.format_exc())

        return {'wiki_hot_recommends': []}
