#!/usr/bin/env python
# -*- coding: utf-8 -*-
import logging
import traceback
from libs.tools import tzlc
from trans2es.models.contrast_similar import ContrastSimilar


class Contrast_Similar_Transfer(object):

    @classmethod
    def get_contrast_similar_data(cls, instance):
        try:
            res = dict()

            res["id"] = instance.id
            res["is_online"] = instance.is_online
            res["is_deleted"] = instance.is_deleted
            res["participant_user_id"] = instance.participant_user_id
            create_time = instance.create_time
            tzlc_create_time = tzlc(create_time)
            res["create_time"] = tzlc_create_time
            update_time = instance.update_time
            tzlc_update_time = tzlc(update_time)
            res["update_time"] = tzlc_update_time
            res["similarity"] = instance.similarity
            res["topic_id_list"] = instance.get_similar_user_id()
            res["contrast_user_id"] = instance.contrast_user_id

            return res
        except:
            logging.error("catch exception,err_msg:%s" % traceback.format_exc())
            return None
