#!/usr/bin/env python
# -*- coding: utf-8 -*-

from __future__ import unicode_literals, absolute_import, print_function
from gm_rpcd.all import bind
import logging
import traceback
import json
from search.utils.topic import TopicUtils
from libs.es import ESPerform
from libs.cache import redis_client
from search.utils.common import *
from libs.es import ESPerform


def get_discover_page_topic_ids(user_id, device_id, size, query_type=TopicPageType.FIND_PAGE):
    try:
        if user_id == -1:
            redis_key = "physical:discover_page" + ":user_id:" + str(user_id) + ":device_id:" + device_id
        else:
            redis_key = "physical:discover_page" + ":user_id:" + str(user_id)

        redis_field_list = [b'have_read_topic_id']
        redis_field_val_list = redis_client.hmget(redis_key, redis_field_list)

        have_read_topic_id_list = json.loads(redis_field_val_list[0]) if redis_field_val_list[0] else []

        recommend_topic_ids = TopicUtils.get_recommend_topic_ids(user_id=user_id, tag_id=0, offset=0, size=size,single_size=size,
                                                           query_type=query_type,
                                                           filter_topic_id_list=have_read_topic_id_list)


        have_read_topic_id_list.extend(recommend_topic_ids)
        redis_dict = {
            "have_read_topic_id": json.dumps(have_read_topic_id_list)
        }
        redis_client.hmset(redis_key, redis_dict)

        return recommend_topic_ids
    except:
        logging.error("catch exception,err_msg:%s" % traceback.format_exc())
        return []


def get_home_recommend_topic_ids(user_id, device_id, tag_id, offset, size, query=None,
                                 query_type=TopicPageType.HOME_RECOMMEND):
    try:
        if query is None:
            if user_id == -1:
                redis_key = "physical:home_recommend" + ":user_id:" + str(
                    user_id) + ":device_id:" + device_id + ":query_type:" + str(query_type)
            else:
                redis_key = "physical:home_recommend" + ":user_id:" + str(user_id) + ":query_type:" + str(query_type)
        else:
            if user_id == -1:
                redis_key = "physical:home_query" + ":user_id:" + str(
                    user_id) + ":device_id:" + device_id + ":query:" + str(query) + ":query_type:" + str(query_type)
            else:
                redis_key = "physical:home_query" + ":user_id:" + str(user_id) + ":query:" + str(
                    query) + ":query_type:" + str(query_type)

        redis_field_list = [b'have_read_topic_list']
        redis_field_val_list = redis_client.hmget(redis_key, redis_field_list)

        tag_recommend_redis_key = "physical:linucb:tag_recommend:device_id:" + str(device_id)

        recommend_tag_list = []
        tag_recommend_val = redis_client.get(tag_recommend_redis_key)
        if tag_recommend_val:
            recommend_tag_list = json.loads(str(tag_recommend_val, encoding="utf-8"))

        recommend_topic_ids = []
        have_read_topic_id_list = list()

        if redis_field_val_list[0] and query is None:
            have_read_topic_id_list = list(json.loads(redis_field_val_list[0]))

        user_similar_score_redis_key = "physical:user_similar_score:user_id:" + str(user_id)
        redis_user_similar_score_redis_val = redis_client.get(user_similar_score_redis_key)
        user_similar_score_redis_list = json.loads(
            redis_user_similar_score_redis_val) if redis_user_similar_score_redis_val else []

        topic_id_list = TopicUtils.get_recommend_topic_ids(user_id=user_id, tag_id=tag_id, offset=offset, size=size,
                                                           single_size=size,query=query, query_type=query_type,
                                                           filter_topic_id_list=have_read_topic_id_list,
                                                           recommend_tag_list=recommend_tag_list,
                                                           user_similar_score_list=user_similar_score_redis_list)
        have_read_group_id_set = set()
        have_read_user_id_set = set()
        unread_topic_id_dict = dict()

        # # 当前页小组数量
        # cur_page_group_num = 0
        # # 当前页用户数量
        # cur_page_user_num = 0
        #
        # for topic_id in topic_id_dict:
        #     if topic_id_dict[topic_id][0] in have_read_group_id_set or topic_id_dict[topic_id][
        #         1] in have_read_user_id_set:
        #         unread_topic_id_dict[topic_id] = topic_id_dict[topic_id]
        #     else:
        #         if isinstance(topic_id_dict[topic_id][0], int) and topic_id_dict[topic_id][
        #             0] > 0 and cur_page_group_num < (size * 0.9):
        #             have_read_group_id_set.add(topic_id_dict[topic_id][0])
        #             have_read_user_id_set.add(topic_id_dict[topic_id][1])
        #             have_read_topic_id_list.append(topic_id)
        #             cur_page_group_num += 1
        #             recommend_topic_ids.append(topic_id)
        #         elif topic_id_dict[topic_id] and cur_page_user_num < (size * 0.1):
        #             have_read_user_id_set.add(topic_id_dict[topic_id][1])
        #             cur_page_user_num += 1
        #             recommend_topic_ids.append(topic_id)
        #             have_read_topic_id_list.append(topic_id)
        #         else:
        #             unread_topic_id_dict[topic_id] = topic_id_dict[topic_id]
        #
        #         if len(recommend_topic_ids) >= size:
        #             break

        # if len(recommend_topic_ids) < size and len(unread_topic_id_dict) > 0:
        #     for unread_topic_id in unread_topic_id_dict:
        #         if len(recommend_topic_ids) < size:
        #             recommend_topic_ids.append(unread_topic_id)
        #             have_read_topic_id_list.append(unread_topic_id)
        #         else:
        #             break

        have_read_topic_id_list.extend(topic_id_list)
        if len(have_read_topic_id_list) > 5000:
            cut_len = len(have_read_topic_id_list)-5000
            have_read_topic_id_list = have_read_topic_id_list[cut_len:]
        redis_dict = {
            "have_read_topic_list": json.dumps(have_read_topic_id_list),
        }
        redis_client.hmset(redis_key, redis_dict)
        # 每个session key保存15分钟
        redis_client.expire(redis_key, 60 * 60 * 24 * 3)

        return topic_id_list
    except:
        logging.error("catch exception,err_msg:%s" % traceback.format_exc())
        return []


@bind("physical/search/query_tag_id_by_topic")
def query_tag_id_by_topic(offset=0, size=10, topic_id_list=[], user_id=-1):
    try:
        return TopicUtils.get_topic_tag_info(offset, size, topic_id_list, user_id)
    except:
        logging.error("catch exception,err_msg:%s" % traceback.format_exc())
        return {}


@bind("physical/search/home_recommend")
def home_recommend(device_id="", user_id=-1, offset=0, size=10, query_type=TopicPageType.HOME_RECOMMEND):
    """
    :remark:首页推荐，目前只推荐日记
    :param session_id:
    :param user_id:
    :param offset:
    :param size:
    :return:
    """
    try:
        if not user_id:
            user_id = -1
        if not isinstance(device_id, str):
            device_id = ""

        recommend_topic_ids = list()

        es_node_load_high_flag = False
        # try:
        #     es_node_load_high_flag = ESPerform.if_es_node_load_high(ESPerform.get_cli())
        # except:
        #     logging.error("catch exception,err_msg:%s" % traceback.format_exc())
        #     es_node_load_high_flag = True

        if es_node_load_high_flag:
            temp_downgrading_key = "physical:home_recommend:user_id:241407656:query_type:1"
            redis_field_list = [b'have_read_topic_list']
            redis_field_val_list = redis_client.hmget(temp_downgrading_key, redis_field_list)
            if redis_field_val_list[0]:
                have_read_topic_id_list = list(json.loads(redis_field_val_list[0]))

                if len(have_read_topic_id_list) > offset:
                    recommend_topic_ids = have_read_topic_id_list[offset:offset+size]
                else:
                    recommend_topic_ids = have_read_topic_id_list[0:size]

        else:
            recommend_topic_ids = get_home_recommend_topic_ids(user_id, device_id, tag_id=0, offset=0, size=size,
                                                           query_type=query_type)

        return {"recommend_topic_ids": recommend_topic_ids}
    except:
        logging.error("catch exception,err_msg:%s" % traceback.format_exc())
        return {"recommend_topic_ids": []}


@bind("physical/search/discover_page")
def discover_page(device_id="", user_id=-1, size=10):
    """
    :remark:首页推荐，目前只推荐日记
    :param session_id:
    :param user_id:
    :param offset:
    :param size:
    :return:
    """
    try:
        if not user_id:
            user_id = -1
        if not isinstance(device_id, str):
            device_id = ""

        recommend_topic_ids = get_discover_page_topic_ids(user_id, device_id, size, query_type=TopicPageType.FIND_PAGE)

        return {"recommend_topic_ids": recommend_topic_ids}
    except:
        logging.error("catch exception,err_msg:%s" % traceback.format_exc())
        return {"recommend_topic_ids": []}


@bind("physical/search/home_query")
def home_query(device_id="", tag_id=-1, user_id=-1, query="", offset=0, size=10):
    """
    :remark:首页搜索，目前只推荐日记
    :param session_id:
    :param user_id:
    :param query:
    :param offset:
    :param size:
    :return:
    """
    try:
        if not user_id:
            user_id = -1
        if not isinstance(device_id, str):
            device_id = ""

        recommend_topic_ids = get_home_recommend_topic_ids(user_id, device_id, tag_id, offset, size, query)
        return {"recommend_topic_ids": recommend_topic_ids}
    except:
        logging.error("catch exception,err_msg:%s" % traceback.format_exc())
        return {"recommend_topic_ids": []}


@bind("physical/search/topic_detail_page_recommend")
def topic_detail_page_recommend(device_id="", user_id=-1, topic_id=-1, topic_group_id=-1, topic_user_id=-1,
                                filter_topic_user_id=False, offset=0, size=10):
    """
    :remark:帖子详情页推荐策略，缺少第一个卡片策略
    :param user_id:
    :param topic_id:
    :param topic_group_id:
    :param topic_user_id:
    :return:
    """
    try:
        if not isinstance(user_id, int):
            user_id = -1

        redis_key = "physical:topic_detail_page_recommend" + ":user_id:" + str(user_id) + ":device_id:" + str(device_id)
        have_read_topic_redis_data = redis_client.get(redis_key)
        have_read_topic_list = json.loads(have_read_topic_redis_data) if have_read_topic_redis_data else []

        # 获取es链接对象
        es_cli_obj = ESPerform.get_cli()

        # 获取帖子标签列表
        topic_tag_list = TopicUtils.get_topic_tag_id_list(topic_id, es_cli_obj)

        result_list = TopicUtils.get_topic_detail_recommend_list(user_id, topic_id, topic_tag_list, topic_group_id,
                                                                 topic_user_id, filter_topic_user_id,
                                                                 have_read_topic_list, offset, size, es_cli_obj)
        recommend_topic_ids_list = list()
        if len(result_list) > 0:
            recommend_topic_ids_list = [item["_source"]["id"] for item in result_list]

        have_read_topic_list.extend(recommend_topic_ids_list)

        have_read_topic_len = len(have_read_topic_list)
        if have_read_topic_len > 5000:
            have_read_topic_list = have_read_topic_list[(have_read_topic_len - 5000):]

        redis_client.set(redis_key, json.dumps(have_read_topic_list))
        return {"recommend_topic_ids": recommend_topic_ids_list}
    except:
        logging.error("catch exception,err_msg:%s" % traceback.format_exc())
        return {"recommend_topic_ids": []}


@bind("physical/search/query_topic_by_tag_aggregation")
def query_topic_by_tag_aggregation(user_id, tag_id, offset, size):
    """
    :remark 按标签聚合召回帖子
    :param tag_id:
    :param offset:
    :param size:
    :return:
    """
    try:
        if not user_id:
            user_id = -1
        if not tag_id:
            tag_id = -1

        result_list = TopicUtils.get_tag_aggregation_topic_id_list(user_id, tag_id, offset, size)
        recommend_topic_ids_list = list()
        if len(result_list) > 0:
            recommend_topic_ids_list = [item["_source"]["id"] for item in result_list]

        return {"recommend_topic_id": recommend_topic_ids_list}
    except:
        logging.error("catch exception,err_msg:%s" % traceback.format_exc())
        return {"recommend_topic_id": []}


@bind("physical/search/topic")
def topic_search(filters, nfilters=None, sorts_by=None, offset=0, size=10):
    """帖子搜索。"""

    try:
        result_list = TopicUtils.list_topic_ids(filters=filters, nfilters=nfilters,
                                                sorts_by=sorts_by, offset=offset, size=size)
        topic_ids = [item["_source"]["id"] for item in result_list["hits"]]
        return {
            "topic_ids": topic_ids,
            "total_count": result_list["total_count"]
        }
    except:
        logging.error("catch exception, err_msg:%s" % traceback.format_exc())
        return {"topic_ids": [], "total_count": 0}


@bind("physical/search/query_topic_by_user_similarity")
def query_topic_by_user_similarity(topic_similarity_score_dict, offset=0, size=10):
    """
    :remark 按帖子所属用户相似度召回帖子
    :param tag_id:
    :param offset:
    :param size:
    :return:
    """
    try:

        must_topic_id_list = list(topic_similarity_score_dict.keys())
        topic_id_list = TopicUtils.get_recommend_topic_ids(tag_id=0, user_id=-1, offset=offset, size=size,single_size=size,
                                                           must_topic_id_list=must_topic_id_list)

        return {"recommend_topic_ids": topic_id_list}
    except:
        logging.error("catch exception,err_msg:%s" % traceback.format_exc())
        return {"recommend_topic_id": []}
