#!/usr/bin/env python
# -*- coding: utf-8 -*-

from django.conf import settings
from django.core.management.base import BaseCommand, CommandError
import traceback
import logging
from libs.es import ESPerform
from django.db import models
import datetime
from .user import User
from .group import Group

class GroupUserRole(models.Model):
    class Meta:
        verbose_name = u'group_user_role'
        verbose_name_plural = u'group_user_role'
        db_table = 'group_user_role'
        app_label = 'api'

    user_id = models.BigIntegerField(verbose_name=u'用户ID')
    group = models.ForeignKey(
        Group, verbose_name=u"关联的小组", null=True, blank=True, default=None, on_delete=models.CASCADE)
    is_online = models.BooleanField(verbose_name=u"是否有效", default=True, db_index=True)
    role_id = models.SmallIntegerField(verbose_name=u'角色ID')
    invite_num = models.IntegerField(verbose_name=u'邀请数量', default=0)