#!/usr/bin/env python
# -*- coding: utf-8 -*-

from gm_rpcd.all import bind
import logging
import traceback
import json
from search.utils.topic import TopicUtils
from libs.es import ESPerform
from libs.cache import redis_client
from search.utils.user import UserUtils
from search.utils.common import *
from libs.es import ESPerform


@bind("physical/search/recommend_user")
def recommend_user(self_user_id, interesting_user_id, offset=0, size=10):
    """
    :remark 点关注推荐用户
    :param self_user_id:
    :param interesting_user_id:
    :param offset:
    :param size:
    :return:
    """
    try:
        if not isinstance(self_user_id, int):
            self_user_id = -1
        if not isinstance(interesting_user_id, int):
            interesting_user_id = -1

        # 获取es链接对象
        es_cli_obj = ESPerform.get_cli()

        # 获取关注用户列表
        (self_attention_user_id_list, recursion_attention_user_id_list) = UserUtils.get_attention_user_list(
            [self_user_id, interesting_user_id], self_user_id, es_cli_obj)

        # 去除自身及感兴趣的用户ID
        self_attention_user_id_list.append(self_user_id)
        self_attention_user_id_list.append(interesting_user_id)

        recommend_user_list = UserUtils.get_recommend_user_list(self_attention_user_id_list,
                                                                recursion_attention_user_id_list, offset, size,
                                                                es_cli_obj)

        return recommend_user_list
    except:
        logging.error("catch exception,err_msg:%s" % traceback.format_exc())
        return []


@bind("physical/search/batch_recommend_user")
def batch_recommend_user(self_user_id, interesting_user_id_list, offset=0, size=10):
    """
    :remark 点关注推荐用户 - 批量接口
    :param self_user_id:
    :param interesting_user_id:
    :param offset:
    :param size:
    :return:
    """
    try:
        if not isinstance(self_user_id, int):
            self_user_id = -1

        # 获取es链接对象
        es_cli_obj = ESPerform.get_cli()

        # 获取关注用户列表
        (need_filter_attention_user_id_list, attention_user_dict_list,
         attention_user_id_list) = UserUtils.get_batch_attention_user_list(interesting_user_id_list, self_user_id,
                                                                           es_cli_obj)

        # 去除自身及感兴趣的用户ID
        need_filter_attention_user_id_list.append(self_user_id)

        recommend_user_dict = UserUtils.get_batch_recommend_user_dict(
            need_filter_attention_user_id_list=need_filter_attention_user_id_list,
            attention_user_id_list=attention_user_id_list, attention_user_dict_list=attention_user_dict_list,
            self_user_id=self_user_id, offset=offset, size=size, es_cli_obj=es_cli_obj)

        logging.info("duan add,recommend_user_dict:%s" % str(recommend_user_dict))
        return recommend_user_dict
    except:
        logging.error("catch exception,err_msg:%s" % traceback.format_exc())
        return {}


@bind("physical/search/search_user")
def search_user(query="", offset=0, size=10):
    """
    :remark 搜索用户
    :param query:
    :param offset:
    :param size:
    :return:

    搜索域：用户名称
    1.识别query：允许模糊匹配

    2.召回部分：全部 线上状态用户

    3.rank部分：一级-是否推荐，二级-发帖数


    """
    try:

        multi_match = {
            "fields": ["nick_name"],
            "type": "cross_fields",
            "operator": "and",
            "query": query

        }
        q = {}
        q["query"] = {
            "bool": {
                "must": [{
                    "multi_match": multi_match
                }, {
                    "term": {
                        "is_online": True
                    }
                }
                ]
            }
        }
        q["sort"] = {
            "is_recommend": {
                "order": "asc"
            },
            "count_topic": {
                "order": "desc"
            },

        }

        result_dict = ESPerform.get_analyze_results(
            ESPerform.get_cli(), sub_index_name="user", query_body=q, offset=offset, size=size
        )

        res = result_dict["hits"]["hits"]

        user_id = [item["_source"]["user_id"] for item in res]

        return {"search_user_id": user_id}

    except:
        logging.error("catch exception,err_msg:%s" % traceback.format_exc())
        return {"search_user_id": []}
