import requests
import time
import datetime
import random
import traceback
from django.conf import settings
import logging

DATABASES = settings.DATABASES

host = DATABASES['default']['HOST']

user = DATABASES['default']['USER']

port = DATABASES['default']['PORT']

db = DATABASES['default']['NAME']

passwd = DATABASES['default']['PASSWORD']

auto_click_url = "http://earth.igengmei.com/api/v1/like"
auto_reply_url = "http://earth.igengmei.com/api/v1/reply/create"
auto_follow_url = "http://earth.igengmei.com/api/v1/follow"
auto_urge_url = "http://earth.igengmei.com/api/v1/user/urge"




def get_majia():
    try:
        data = open("/srv/apps/physical/majia/majia_email.txt")
        list = []
        for i in data:
            list.append(i.strip('\n').strip(','))
        maj = random.randint(1, len(list))
        user_id = list[maj - 1]
        return user_id

    except:
        logging.error("catch exception,get_majia:%s" % traceback.format_exc())
        return None


def get_cookies(user_id):
    try:
        with open("/srv/apps/physical/majia/user_session.txt", 'r') as f:
            try:
                data = f.readlines()
            except:
                data = None

        list = []
        for i in data:
            list.append(i.strip('\n').split(","))

        for i in list:

            if user_id == i[0]:
                return (i[1])
    except:

        return None


def login():
    try:
        user_id = get_majia()

        cookies = get_cookies(user_id)

        if cookies is not None:
            return {'sessionid': cookies}

    except:

        logging.error("catch exception,logins:%s" % traceback.format_exc())

        return None


def click(cookies_get, id):
    try:
        post_dict = {
            'type': 0,
            'id': id
        }
        response = requests.post(url=auto_click_url,
                                 cookies=cookies_get,
                                 data=post_dict)

        logging.info("response.text:%s" % response.text)

    except:

        logging.error("catch exception,logins:%s" % traceback.format_exc())


def reply(cookies_get, id, content):
    try:
        post_dict = {
            'topic_id': id,
            'content': content
        }
        response = requests.post(url=auto_reply_url,
                                 cookies=cookies_get,
                                 data=post_dict)

        logging.info("response.text:%s" % response.text)

    except:

        logging.error("catch exception,logins:%s" % traceback.format_exc())


def time_conv(minutest):
    try:
        now = datetime.datetime.now()
        yes_time = now - datetime.timedelta(minutes=minutest)
        print(yes_time)
        return yes_time

    except:
        return None


def get_comments():
    try:
        data = open("/srv/apps/physical/majia/guanshui.txt", "r")
        list_guanshui = []
        for i in data:
            list_guanshui.append(i)
        num1 = random.randint(0, 30)
        num2 = random.randint(30, 70)
        num3 = random.randint(70, len(list_guanshui))

        comment1 = list_guanshui[num1 - 1]
        comment2 = list_guanshui[num2 - 1]
        comment3 = list_guanshui[num3 - 1]

        comment_list = [comment1, comment2, comment3]
        return comment_list

    except:

        return None
