#!/usr/bin/env python
# -*- coding: utf-8 -*-

import logging
import traceback
import datetime
import json
from libs.es import ESPerform
from libs.cache import redis_client

class PickUtils(object):

    @classmethod
    def refresh_redis_data(cls,have_read_celebrity_list,redis_cli,redis_key,key_exist):
        try:
            if key_exist:
                redis_cli.set(redis_key,json.dumps(have_read_celebrity_list))
            else:
                now = datetime.datetime.now()

                str_end_time = "%s-%s-%s 23:59:59" % (now.year, now.month, now.day)
                end_time = datetime.datetime.strptime(str_end_time, "%Y-%m-%d %H:%M:%S")

                valid_seconds = (end_time - now).seconds

                redis_cli.setex(redis_key,json.dumps(have_read_celebrity_list),valid_seconds)

            return True
        except:
            logging.error("catch exception,err_msg:%s" % traceback.format_exc())
            return False