#!/usr/bin/env python
# -*- coding: utf-8 -*-

from gm_rpcd.all import bind
import logging
import traceback
import json
from libs.cache import redis_client
from libs.es import ESPerform
from search.utils.group import GroupUtils
from search.utils.common import GroupSortTypes
from libs.es import ESPerform
from trans2es.models.pictorial import PictorialTopics


def get_product_sku(query='', offset=0, size=10, sort_type=PRODUCT_ORDER_TYPE.DEFAULT, filters={}):
    try:
        multi_fields = {
            'cn_name_pre': 2,
            'en_name_pre': 2,
            'alias': 2,
            'brand_cn_name': 2,
            'brand_en_name': 2,
            'brand_alias': 2,
            'category_cn_name': 2,
            "effect_cn_name": 2
        }
        query_fields = ['^'.join((k, str(v))) for (k, v) in multi_fields.items()]
        multi_match = {
            'query': query,
            'type': 'cross_fields',
            'operator': 'and',
            'fields': query_fields,
        }
        q = []

        if query != '':
            q["query"] = {
                "bool": {
                    "should": {
                        "multi_match": multi_match
                    },
                    "minimum_should_match": 1
                }
            }


    except:
        logging.error("catch exception, query_sku:%s" % traceback.format_exc())
        return []
