#!/usr/bin/env python
# -*- coding: utf-8 -*-

from django.conf import settings
from django.core.management.base import BaseCommand, CommandError
import traceback
import logging
from libs.es import ESPerform
from django.db import models
import datetime
import time
from libs.tools import tzlc

from .group_user_role import GroupUserRole
from .tag import AccountUserTag
from .topic import Topic
from .user_extra import UserExtra


class User(models.Model):
    class Meta:
        verbose_name = u'用户'
        db_table = 'account_user'

    id = models.IntegerField(verbose_name="主键ID",primary_key=True)
    user_id = models.BigIntegerField(verbose_name=u'用户id', unique=True)
    nick_name = models.CharField(verbose_name=u'昵称', max_length=255, default='')
    profile_pic = models.CharField(verbose_name=u'头像', max_length=300)
    gender = models.SmallIntegerField(verbose_name=u'性别')
    city_id = models.CharField(verbose_name=u'城市id', max_length=60)
    country_id = models.CharField(verbose_name='国家id', max_length=40)
    is_online = models.BooleanField(verbose_name="是否上线")
    is_deleted = models.BooleanField(verbose_name='是否删除')
    create_time = models.DateTimeField(verbose_name=u'创建时间',default=datetime.datetime.fromtimestamp(0))
    update_time = models.DateTimeField(verbose_name=u'更新时间', default=datetime.datetime.fromtimestamp(0))

    def get_is_recommend_flag(self):
        is_shadow = False
        is_recommend = False
        query_sql = UserExtra.objects.filter(user_id=self.user_id,is_deleted=False,is_online=True)
        for record in query_sql:
            is_recommend = record.is_recommend
            is_shadow = record.is_shadow

        return (is_recommend,is_shadow)

    def get_latest_topic_time_val(self):
        latest_topic_time_val = -1

        # 获取该用户最新发帖时间
        topic_records = Topic.objects.filter(user_id=self.user_id).order_by("-update_time").values_list("update_time",flat=True).first()
        if topic_records:
            tzlc_topic_update_time = tzlc(topic_records)
            latest_topic_time_val = int(time.mktime(tzlc_topic_update_time.timetuple()))

        """
        check_index = 0
        for record in topic_records:
            topic_update_time = record.update_time
            tzlc_topic_update_time = tzlc(topic_update_time)
            latest_topic_time_val = int(time.mktime(tzlc_topic_update_time.timetuple()))
            check_index += 1
            if check_index >= 1:
                break        
        """

        return latest_topic_time_val


    def get_follow_user_id_list(self):
        follow_user_id_list = list()
        user_follows = self.userfollow.filter(is_online=True)
        for user_follow in user_follows:
            follow_user_id_list.append(user_follow.follow_id)

        follow_user_detail_list = list()
        sql_data_list = User.objects.filter(user_id__in=follow_user_id_list)
        for detail_data in sql_data_list:
            item = {
                "user_id":detail_data.user_id,
                "country_id":detail_data.country_id
            }
            follow_user_detail_list.append(item)

        return follow_user_detail_list

    def get_attention_group_id_list(self):
        try:
            attention_group_id_list = list()
            query_results = GroupUserRole.objects.filter(is_online=True,user_id=self.user_id)
            for item in query_results:
                item_dict = {
                    "group_id": item.group_id,
                    "update_time_val":time.mktime(tzlc(item.update_time).timetuple())
                }
                attention_group_id_list.append(item_dict)

            return attention_group_id_list
        except:
            logging.error("catch exception,err_msg:%s" % traceback.format_exc())
            return []

    def get_pick_user_id_list(self):
        pick_topic_id_list = list()
        user_picks = self.user_pick.filter(is_deleted=False,is_pick=True)
        for user_pick in user_picks:
            pick_topic_id_list.append(user_pick.picktopic_id)

        pick_user_id_list = []
        topic_sql_list = Topic.objects.filter(id__in=pick_topic_id_list)
        for topic_data in topic_sql_list:
            pick_user_id_list.append(topic_data.user_id)

        pick_user_id_list = tuple(pick_user_id_list)
        pick_user_detail_list = list()
        sql_data_list = User.objects.filter(user_id__in=pick_user_id_list)
        for detail_data in sql_data_list:
            item = {
                "user_id":detail_data.user_id,
                "country_id":detail_data.country_id
            }
            pick_user_detail_list.append(item)

        return pick_user_detail_list

    def get_same_group_user_id_list(self):
        same_group_user_id_list = list()
        group_items_list = GroupUserRole.objects.filter(user_id=self.user_id)
        for group_item in group_items_list:
            group_id = group_item.group_id
            user_items_list = GroupUserRole.objects.filter(group_id=group_id)
            for user_items_list in user_items_list:
                same_group_user_id_list.append(user_items_list.user_id)

        same_group_detail_list = list()
        sql_data_list = User.objects.filter(user_id__in=same_group_user_id_list)
        for detail_data in sql_data_list:
            item = {
                "user_id":detail_data.user_id,
                "country_id":detail_data.country_id
            }
            same_group_detail_list.append(item)

        return same_group_detail_list


    def get_user_tag_id_list(self):
        try:
            user_tag_id_list = list()

            query_results = AccountUserTag.objects.filter(user=self.user_id,is_deleted=False)
            for item in query_results:
                user_tag_id_list.append(item.tag_id)

            return user_tag_id_list
        except:
            logging.error("catch exception,err_msg:%s" % traceback.format_exc())
            return []

