#!/usr/bin/env python
# -*- coding: utf-8 -*-

from gm_rpcd.all import bind
import logging
import traceback
import json
from libs.cache import redis_client
from libs.es import ESPerform
from search.utils.product import ProductUtils
from search.utils.common import GroupSortTypes
from libs.es import ESPerform


@bind("physical/search/query_product_sku")
def product_hot_sort(query='', offset=0, size=10, filters={}):
    '''
    商品sku排序
    :param query:
    :param offset:
    :param size:
    :param sort_type:
    :param filters:
    :return:
    '''
    try:
        res = ProductUtils.get_product_sku(query=query, offset=offset, size=size, filters=filters)

        product_list = []
        res_hit = res["hits"]

        for item in res_hit:
            product_id = item["_source"]["id"]
            product_list.append(product_id)

        return {"product_hot_ids": product_list}
    except:
        logging.error("catch exception,err_msg:%s" % traceback.format_exc())
        return {"product_hot_ids": []}
