#!/usr/bin/env python
# -*- coding: utf-8 -*-

from gm_rpcd.all import bind
import logging
import traceback
import json
from libs.cache import redis_client
from libs.es import ESPerform
from search.utils.pick import PickUtils
from search.utils.common import PickType

@bind("physical/search/pick_celebrity")
def pick_celebrity(user_id,pick_id,offset=0,size=10):
    try:
        if not isinstance(user_id,int):
            user_id = -1

        have_read_pick_celebrity_ids = list()

        redis_key = "physical:pick_celebrity:" + "user_id:" + str(user_id) + ":pick_id:" + str(pick_id)

        if user_id != -1:
            try:
                offset = 0
                redis_celebrity_info = redis_client.get(redis_key)
                if redis_celebrity_info:
                    have_read_pick_celebrity_ids = json.loads(redis_celebrity_info)
            except:
                logging.error("catch exception,err_msg:%s" % traceback.format_exc())
                pass

        recommend_pick_celebrity_list = PickUtils.get_recommend_celebrity_id_list(pick_id,have_read_pick_celebrity_ids,offset,size)

        if len(recommend_pick_celebrity_list)>0 and user_id!=-1:
            total_read_celebrity_ids = have_read_pick_celebrity_ids + recommend_pick_celebrity_list
            PickUtils.refresh_redis_data(have_read_celebrity_list=total_read_celebrity_ids,
                                         redis_cli=redis_client,redis_key=redis_key)

        return {"recommend_pick_celebrity_ids": recommend_pick_celebrity_list}
    except:
        logging.error("catch exception,err_msg:%s" % traceback.format_exc())
        return {"recommend_pick_celebrity_ids":[]}


@bind("physical/search/pick_topic")
def pick_topic(user_id,pick_id,offset=0,size=10):
    try:
        if not isinstance(user_id,int):
            user_id = -1

        have_read_pick_topic_ids = list()

        redis_key = "physical:pick_topic:" + "user_id:" + str(user_id) + ":pick_id:" + str(pick_id)

        if user_id != -1:
            try:
                offset = 0
                redis_celebrity_info = redis_client.get(redis_key)
                if redis_celebrity_info:
                    have_read_pick_topic_ids = json.loads(redis_celebrity_info)
            except:
                logging.error("catch exception,err_msg:%s" % traceback.format_exc())
                pass

        q = dict()
        functions_list = [
            {
                "filter": {"match": {"content_level": 5}},
                "weight": 5
            },
            {
                "filter": {"match": {"content_level": 4}},
                "weight": 3
            },
            {
                "filter": {"match": {"content_level": 3}},
                "weight": 2
            },
            {
                "gauss": {
                    "update_time": {
                        "scale": "1d",
                        "decay": 0.5
                    }
                }
            }
        ]

        query_function_score = {
            "query":{
                "bool":{
                    "must":[
                        {"term":{"pick_id_list":pick_id}},
                        {"range": {"content_level": {"gte": 3, "lte": 5}}}
                    ],
                    "must_not": {
                        "terms": {
                            "id": have_read_pick_topic_ids
                        }
                    },
                }
            },
            "score_mode": "sum",
            "boost_mode": "replace",
            "functions":functions_list
        }

        q["query"] = {
            "function_score":query_function_score
        }
        q["sort"] = [
            "_score"
        ]
        q["_source"] = {
            "include":["id"]
        }
        result_dict = ESPerform.get_search_results(ESPerform.get_cli(),sub_index_name="topic",query_body=q,offset=offset,size=size)

        recommend_pick_topic_list = []
        if len(result_dict["hits"]) > 0:
            recommend_pick_topic_list = [item["_source"]["id"] for item in result_dict["hits"]]

        if len(recommend_pick_topic_list)>0 and user_id!=-1:
            total_read_topic_ids = have_read_pick_topic_ids + recommend_pick_topic_list
            PickUtils.refresh_redis_data(have_read_celebrity_list=total_read_topic_ids,
                                         redis_cli=redis_client,redis_key=redis_key,if_expire=False)

        return {"recommend_pick_topic_ids": recommend_pick_topic_list}

    except:
        logging.error("catch exception,err_msg:%s" % traceback.format_exc())
        return {"recommend_pick_topic_ids":[]}


@bind("physical/search/pick_query")
def pick_query(query="",pick_id=-1,query_type=PickType.TOPIC_PICK,offset=0,size=10):
    """
    :remark 榜单搜索
    :param query:
    :param pick_id:
    :param query_type:
    :param offset:
    :param size:
    :return:
    """
    try:
        pick_query_result_list = []
        if query_type == PickType.TOPIC_PICK:
            pick_query_result_list = PickUtils.get_topic_pick_query(query,pick_id,offset,size)
        elif query_type == PickType.CELEBRITY_PICK:
            pick_query_result_list = PickUtils.get_celebrity_pick_query(query,pick_id,offset,size)

        return {"pick_query_result_list":pick_query_result_list}
    except:
        logging.error("catch exception,err_msg:%s" % traceback.format_exc())
        return {"pick_query_result_list":[]}




