#!/usr/bin/env python
# -*- coding: utf-8 -*-

from django.conf import settings
from django.core.management.base import BaseCommand, CommandError
import traceback
import logging
from libs.es import ESPerform
from django.db import models
import datetime
from .pick_topic import PickTopic
from .tag import TopicTag

class Topic(models.Model):
    class Meta:
        verbose_name = u'日记'
        db_table = 'topic'

    id = models.IntegerField(verbose_name='日记ID',primary_key=True)
    name = models.CharField(verbose_name='日记名称',max_length=100)
    group_id = models.IntegerField(verbose_name='用户所在组ID')
    user_id = models.IntegerField(verbose_name='用户ID')
    description = models.CharField(verbose_name='日记本描述',max_length=200)
    content = models.CharField(verbose_name='日记本内容',max_length=1000)
    share_num = models.IntegerField(verbose_name='')
    vote_num = models.IntegerField(verbose_name='点赞数')
    reply_num = models.IntegerField(verbose_name='回复数')
    cover = models.CharField(verbose_name='',max_length=200)
    is_online = models.BooleanField(verbose_name='是否上线')
    is_deleted = models.BooleanField(verbose_name='是否删除')
    content_level = models.CharField(verbose_name='内容等级',max_length=3)
    create_time = models.DateTimeField(verbose_name=u'日记创建时间',default=datetime.datetime.fromtimestamp(0))
    update_time = models.DateTimeField(verbose_name=u'日记更新时间', default=datetime.datetime.fromtimestamp(0))


    def get_pick_id_info(self):
        try:
            pick_id_list = list()
            query_list = PickTopic.objects.get(topic_id=self.id)
            for item in query_list:
                pick_id_list.append(item.pick_id)

            return tuple(pick_id_list)
        except:
            logging.error("catch exception,err_msg:%s" % traceback.format_exc())
            return ()

    def get_topic_tag_id_list(self):
        try:
            topic_tag_id_list = list()

            query_results = TopicTag.objects.get(topic_id=self.id)
            for item in query_results:
                topic_tag_id_list.append(item.tag_id)

            return topic_tag_id_list
        except:
            logging.error("catch exception,err_msg:%s" % traceback.format_exc())
            return None