#!/usr/bin/env python
# -*- coding: utf-8 -*-


from django.db import models
import datetime

manager = lambda: models.Manager().db_manager(using='face')


class FaceUserContrastSimilar(models.Model):
    class Meta:
        verbose_name = u"用户脸相似表"
        db_table = "face_user_contrast_similar"

    objects = manager()

    id = models.IntegerField(verbose_name="主键ID", primary_key=True)
    is_online = models.BooleanField(verbose_name="是否上线")
    is_deleted = models.BooleanField(verbose_name="是否删除")
    participant_user_id = models.IntegerField(verbose_name=u'参与者用户ID')
    similarity = models.FloatField(verbose_name=u'相似度', default=0)
    create_time = models.DateTimeField(verbose_name=u'创建时间', default=datetime.datetime.fromtimestamp(0))
    update_time = models.DateTimeField(verbose_name=u'更新时间', default=datetime.datetime.fromtimestamp(0))
