#!/usr/bin/env python
# -*- coding: utf-8 -*-

# from django.conf import settings
# from django.core.management.base import BaseCommand, CommandError
import traceback
import logging
from django.db import models
import datetime
from django.db.models import QuerySet
from .topic import Topic

# manager = lambda: models.Manager().db_manager(using='face')


class ContrastSimilar(models.Model):
    class Meta:
        app_label = 'face'
        verbose_name = u"用户脸相似度表"
        db_table = "face_user_contrast_similar"

    class ContrastSimilarManager(models.Manager):

        def get_queryset(self):
            qs = QuerySet(self.model).using("face")
            return qs

    objects = models.Manager().db_manager(using='face')
    id = models.IntegerField(verbose_name="主键ID", primary_key=True)
    is_online = models.BooleanField(verbose_name="是否上线")
    is_deleted = models.BooleanField(verbose_name="是否删除")
    participant_user_id = models.IntegerField(verbose_name=u'参与者用户ID')
    contrast_user_id = models.IntegerField(verbose_name="对照者用户ID")
    similarity = models.FloatField(verbose_name=u'相似度', default=0)
    create_time = models.DateTimeField(verbose_name=u'创建时间', default=datetime.datetime.fromtimestamp(0))
    update_time = models.DateTimeField(verbose_name=u'更新时间', default=datetime.datetime.fromtimestamp(0))

    # @classmethod
    # def get_similar_user_id(cls):
    #
    #     try:
    #         similar_user_id_list = list()
    #         if cls.objects.similarity > 0.3:
    #             query_list = Topic.objects.filter(user_id=cls.objects.participant_user_id, is_deleted=False,
    #                                               is_online=True,
    #                                               content_level__in=("3", "4", "5"))
    #             for item in query_list:
    #                 if item.user_id != cls.objects.participant_user_id:
    #                     similar_user_id_list.append(item.id)
    #
    #             return similar_user_id_list
    #     except:
    #         logging.error("catch exception,err_msg:%s" % traceback.format_exc())
    #         return []
