#!/usr/bin/env python
# -*- coding: utf-8 -*-
import os
import sys
import logging
import traceback
from libs.tools import tzlc

class UserTransfer(object):

    @classmethod
    def get_user_data(cls,instance):
        try:
            res = dict()

            res["id"] = instance.id
            res["user_id"] = instance.user_id
            res["nick_name"] = instance.nick_name
            res["profile_pic"] = instance.profile_pic
            res["gender"] = instance.gender
            res["city_id"] = instance.city_id
            res["country_id"] = instance.country_id
            res["is_online"] = instance.is_online
            res["create_time"] = tzlc(instance.create_time)
            res["update_time"] = tzlc(instance.update_time)

            res["tag_list"] = ""
            res["attention_user_id_list"] = instance.get_follow_user_id_list()
            res["pick_user_id_list"] = instance.get_pick_user_id_list()
            res["same_group_user_id_list"] = instance.get_same_group_user_id_list()

            return res
        except:
            logging.error("catch exception,err_msg:%s" % traceback.format_exc())
            return None