#!/usr/bin/env python
# -*- coding: utf-8 -*-

from gm_rpcd.all import bind
import logging
import traceback
import json
from libs.cache import redis_client
from libs.es import ESPerform
from search.utils.group import GroupUtils
from search.utils.common import GroupSortTypes
from libs.es import ESPerform
from trans2es.models.pictorial import PictorialTopics


class ProductUtils(object):

    @classmethod
    def get_product_sku(cls, query='', offset=0, size=10, filters={}):
        try:
            multi_fields = {
                'cn_name_pre': 2,
                'en_name_pre': 2,
                'alias': 2,
                'brand_cn_name': 2,
                'brand_en_name': 2,
                'brand_alias': 2,
                'category_cn_name': 2,
                "effect_cn_name": 2
            }
            query_fields = ['^'.join((k, str(v))) for (k, v) in multi_fields.items()]
            multi_match = {
                'query': query,
                'type': 'cross_fields',
                'operator': 'and',
                'fields': query_fields,
            }

            sku_must_flter = cls.sku_filter(filters)
            logging.info("get  sku_must_flter:%s " % sku_must_flter)
            logging.info("get  sku_must_flter:%s " % type(sku_must_flter))

            q = {
                "query": {
                    "bool": {
                        "must": sku_must_flter
                    }
                }
            }

            if query != '':
                q = {
                    "query": {
                        "bool": {
                            "must": sku_must_flter,
                            "should": {
                                "multi_match": multi_match
                            },
                            "minimum_should_match": 1
                        }
                    }
                }

            q["sort"] = [{"comment_nums": {"order": "desc"}}]

            logging.info("get product query:%s" % q)

            result_dict = ESPerform.get_search_results(ESPerform.get_cli(), sub_index_name="product", query_body=q,
                                                       offset=offset, size=size)

            return result_dict
        except:
            logging.error("catch exception, query_sku:%s" % traceback.format_exc())
            return []

    @classmethod
    def sku_filter(cls, filters):

        """处理过滤器部分。"""
        logging.info("get filters:%s" % filters)

        f = [
            {'term': {"have_image": True}},
            {'term': {"is_online": True}},
            {'term': {"is_deleted": False}},
        ]

        if not filters:
            return f

        for k, v in filters.items():

            if v in (None, '', []):
                continue

            if k == "brand":
                f.append({"term": {"brand_cn_name": v}})

            if k == "effect":
                f.append({"term": {"effect_cn_name": v}})

            if k == "category":
                f.append({"term": {"category_cn_name": v}})

        return f
