#!/usr/bin/env python
# -*- coding: utf-8 -*-
import os
import sys
import logging
import traceback
from libs.tools import tzlc
from trans2es.models.topic import Topic


class PictorialTransfer(object):

    def __init__(self):
        pass

    @classmethod
    def get_offline_score(cls, instance, topic_id_list):
        try:
            total_offline_score = 0
            topic_image_num = 0
            for topic_id in topic_id_list:
                topic_image_num += Topic.get_topic_image_num(topic_id)

            if topic_image_num >= 6 and topic_image_num <= 10:
                total_offline_score += 30
            elif topic_image_num > 10 and topic_image_num <= 20:
                total_offline_score += 60
            elif topic_image_num > 20 and topic_image_num <= 50:
                total_offline_score += 80
            elif topic_image_num > 50:
                total_offline_score += 100

            total_offline_score += instance.add_score
            if instance.is_recommend:
                total_offline_score += 100

            return total_offline_score
        except:
            logging.error("catch exception,err_msg:%s" % traceback.format_exc())
            return 0

    @classmethod
    def get_poctorial_data(cls, instance):
        try:
            res = dict()

            res["id"] = instance.id
            res["is_online"] = instance.is_online
            res["is_deleted"] = instance.is_deleted
            res["is_recommend"] = instance.is_recommend
            res["name"] = instance.name
            res["description"] = instance.description
            res["topic_num"] = instance.topic_num
            res["creator_id"] = instance.creator_id
            res["icon"] = instance.icon
            create_time = instance.create_time
            tzlc_create_time = tzlc(create_time)
            res["create_time"] = tzlc_create_time
            update_time = instance.update_time
            tzlc_udpate_time = tzlc(update_time)
            res["update_time"] = tzlc_udpate_time
            res["high_quality_topic_num"] = instance.get_high_quality_topic_num()
            tag_id_list = instance.get_tag_by_id()
            res["tag_id"] = tag_id_list
            res["tag_name"] = instance.get_tag_by_name(tag_id_list)
            res["topic_id_list"] = instance.get_topic_id()
            res["effective"] = instance.get_effective(res["topic_id_list"])
            res["offline_score"] = cls.get_offline_score(instance, res["topic_id_list"])
            res["is_default"] = instance.is_default
            res["is_cover"] = True if instance.has_cover else False
            res["edit_tag_list"] = instance.get_edit_tag_list()
            res["reply_score"] = instance.get_reply_score()
            res["topic_vote_number"] = instance.get_topic_vote_number()
            res["activity_join"] = instance.get_activity_join()
            return res
        except:
            logging.error("catch exception,err_msg:%s" % traceback.format_exc())
            return dict()
