#!/usr/bin/env python
# -*- coding: utf-8 -*-

from gm_rpcd.all import bind
import logging
import traceback
import json
from libs.cache import redis_client
from libs.es import ESPerform
from search.utils.group import GroupUtils
from search.utils.common import GroupSortTypes
from libs.es import ESPerform
from trans2es.models.pictorial import PictorialTopics
from trans2es.models.tag import RegisterShowTag, Tag
import random


@bind("physical/search/search_hotword")
def search_hotword(device_id=-1):
    """
    :remark:搜索页的热门灵感
    内容组成：搜索推荐热词register_show_tag
             个性化标签physical:linucb:tag_recommend:device_id:
             核心词，需要去重community_tag  collection 1
    ①先从后台随机取最多6个搜索推荐热词，不够6个则有多少取多少
    ②然后随机取和推荐热词一样数量的linUCB标签，取不够数则取核心标签，linUCB+核心词去重后的数量要和搜索推荐热词的数量一样
    ③最后打乱顺序填入到热门灵感中，超过3行的标签弃掉，不够3行不用管
    :param query:
    :param offset:
    :param size:
    :return:
    """
    try:
        all_tag_name_list = set()
        # 获取搜索推荐热词
        results_registr_tag = RegisterShowTag.objects.filter(is_deleted=False, is_online=1).count()

        # 获取符合条件的核心词
        q = {}
        q["query"] = {
            "bool": {
                "must": [
                    {"term": {
                        "is_online": True
                    }},
                    {"term": {
                        "collection": 1
                    }
                    }
                ]
            }
        }
        es_cli_obj = ESPerform.get_cli()
        result_dict = ESPerform.get_search_results(es_cli_obj, "tag", q, 0, 10000)
        logging.info("get result_dict:%s" % result_dict)
        results_tag = result_dict["hits"]["total"]
        logging.info("get totoal:%s" % results_tag)

        # results_tag = Tag.objects.filter(is_online=True, collection=1).count()
        tag_id = random.sample(range(1, results_registr_tag), 1)
        results_tag_chose = Tag.objects.filter(id__in=tag_id).values_list("name", flat=True)
        for i in results_tag_chose:
            all_tag_name_list.add(i)

        # 获取个性化标签
        linucb_recommend_redis_prefix = "physical:linucb:tag_recommend:device_id:"
        tag_recommend_redis_key = linucb_recommend_redis_prefix + str(device_id)
        linucb_recommend_tag_data = redis_client.get(tag_recommend_redis_key)
        linucb_recommend_tag_list = json.loads(linucb_recommend_tag_data) if linucb_recommend_tag_data else []
        for item in linucb_recommend_tag_list:
            results_tag_recommend = Tag.objects.filter(id=item, is_online=True).values_list("name", flat=True)
            all_tag_name_list.add(results_tag_recommend[0])
            if len(all_tag_name_list) == 12:
                return {"recommend_tag_name": list(all_tag_name_list)}

            logging.info("get all_tag_name_list02:%s" % all_tag_name_list)

        # 取不够数则取核心标签
        if len(all_tag_name_list) < 12:
            for i in range(0, 12):
                tag_id = random.sample(range(1, results_tag), 12 - len(all_tag_name_list))
                results_tag_hexin = Tag.objects.filter(id__in=tag_id).values_list("name", flat=True)
                if results_tag_hexin not in all_tag_name_list:
                    all_tag_name_list.add(results_tag_hexin[0])
                    if len(all_tag_name_list) >= 12:
                        return {"recommend_tag_name": list(all_tag_name_list)}

    except:
        logging.error("catch exception,err_msg:%s" % traceback.format_exc())
        return {"recommend_tag_name": []}
