# -*- coding: UTF-8 -*-
# !/usr/bin/env python

import numpy as np
import redis
from libs.cache import redis_client
import logging
import traceback
import json
import pickle
from django.conf import settings
from trans2es.models.tag import AccountUserTag,CommunityTagFollow
from libs.es import ESPerform
import libs.tools as Tools
from search.utils.common import *


class RegisterUserTag(object):

    linucb_device_id_matrix_redis_prefix = "physical:linucb:device_id:"
    linucb_device_id_recommend_redis_prefix = "physical:linucb:tag_recommend:device_id:"
    linucb_device_id_recommend_topic_id_prefix = "physical:linucb:topic_recommend:device_id:"
    tag_topic_id_redis_prefix = "physical:tag_id:topic_id_list:"

    linucb_user_id_matrix_redis_prefix = "physical:linucb:user_id:"
    linucb_user_id_recommend_redis_prefix = "physical:linucb:tag_recommend:user_id:"
    linucb_user_id_recommend_topic_id_prefix = "physical:linucb:topic_recommend:user_id:"

    linucb_device_id_register_tag_topic_id_prefix = "physical:linucb:register_tag_topic_recommend:device_id:"
    linucb_user_id_register_tag_topic_id_prefix = "physical:linucb:register_tag_topic_recommend:user_id:"

    # 用户关注标签
    linucb_register_user_tag_key = "physical:linucb:register_user_tag_info"
    # # 用户关注标签
    # linucb_user_attention_tag_key = "physical:linucb:user_attention_tag_info"
    # # 用户喜好标签（注册勾选 + 关注）
    # linucb_user_like_tag_key = "physical:linucb:user_like_tag_info"
    @classmethod
    def get_user_attention_tag(cls, pk_list):
        """
        :remark 获取用户关注标签
        :param pk_list:
        :return:
        """
        try:
            user_id_dict = dict()
            query_results = CommunityTagFollow.objects.filter(pk__in=pk_list,is_deleted=False,is_online=True)
            for item in query_results:
                tag_id = item.tag_id
                user_id = item.user_id

                user_tag_list = CommunityTagFollow.objects.filter(user_id=user_id,is_deleted=False,is_online=True).values_list("tag_id", flat=True)
                user_id_dict[user_id] = user_tag_list

                user_register_tag_list = AccountUserTag.objects.filter(user=user_id,is_deleted=False).values_list("tag_id", flat=True)
                user_id_dict[user_id].extend(user_register_tag_list)

            for user_id in user_id_dict:
                # redis_user_tag_id_data = redis_client.hget(cls.linucb_register_user_tag_key, user_id)
                # redis_user_tag_id_list = json.loads(redis_user_tag_id_data) if redis_user_tag_id_data else []
                # redis_user_tag_id_list.extend(user_id_dict[user_id])
                redis_client.hset(cls.linucb_register_user_tag_key, user_id, json.dumps(list(set(user_id_dict[user_id]))))
        except:
            logging.error("catch exception,err_msg:%s" % traceback.format_exc())


    @classmethod
    def get_register_user_tag(cls,pk_list):
        """
        :remark 用户注册时选的标签
        :param pk_list:
        :return:
        """
        try:
            user_id_dict = dict()
            query_results = AccountUserTag.objects.filter(pk__in=pk_list)
            for item in query_results:
                tag_id = item.tag_id
                user_id = item.user
                user_tag_list = AccountUserTag.objects.filter(user=user_id).values_list("tag_id", flat=True)
                user_id_dict[user_id] = user_tag_list

                user_follow_tag_list = CommunityTagFollow.objects.filter(user_id=user_id,is_deleted=False,is_online=True).values_list("tag_id", flat=True)
                user_id_dict[user_id].extend(user_follow_tag_list)

            for user_id in user_id_dict:
                # redis_user_tag_id_data = redis_client.hget(cls.linucb_register_user_tag_key, user_id)
                # redis_user_tag_id_list = json.loads(redis_user_tag_id_data) if redis_user_tag_id_data else []
                # redis_user_tag_id_list.extend(user_id_dict[user_id])
                redis_client.hset(cls.linucb_register_user_tag_key, user_id, json.dumps(list(set(user_id_dict[user_id]))))

        except:
            logging.error("catch exception,err_msg:%s" % traceback.format_exc())
