#!/usr/bin/env python
# -*- coding: utf-8 -*-

from __future__ import unicode_literals, absolute_import, print_function
import os
import sys
import logging
import traceback
from libs.tools import tzlc
from trans2es.models.topic import Topic
from trans2es.models.tag import TopicTag, CommunityTagType, CommunityTagTypeRelation
import datetime


class TagTransfer(object):

    @classmethod
    def get_tag_data(cls, instance):
        try:
            res = dict()

            res["id"] = instance.id

            tag_name_terms_list = list()
            for i in range(len(instance.name)):
                for j in range(i, len(instance.name) + 1):
                    name_term = instance.name[i:j].strip()
                    if name_term:
                        tag_name_terms_list.append(name_term)

            res["suggest"] = {
                "input": tag_name_terms_list,
                "contexts": {
                    "is_online": [instance.is_online],
                    "is_deleted": [instance.is_deleted]
                }
            }
            res["name"] = instance.name
            res["is_online"] = instance.is_online
            res["is_deleted"] = instance.is_deleted

            res["near_new_topic_num"] = 0
            if instance.is_online == True and instance.is_deleted == False:
                topic_id_list = list()
                sql_result_list = TopicTag.objects.filter(tag_id=instance.id).values_list("topic_id", flat=True)
                for item_id in sql_result_list:
                    topic_id_list.append(item_id)
                topic_nums = 0
                time_base_val = datetime.datetime.strftime(datetime.datetime.now() + datetime.timedelta(-7), "%Y-%m-%d")
                for i in range(0, len(topic_id_list), 1000):
                    topic_num = Topic.objects.filter(id__in=topic_id_list[i:i + 1000],
                                                     create_time__gte=time_base_val).count()
                    topic_nums += topic_num

                res["near_new_topic_num"] = topic_num

            tag_type_sql_list = CommunityTagTypeRelation.objects.filter(tag_id=instance.id).values_list("tag_type_id",
                                                                                                        flat=True)
            tag_type_list = list()
            for tag_type_id in tag_type_sql_list:
                tag_type_list.append(tag_type_id)

            res["tag_type"] = tag_type_list

            return res
        except:
            logging.error("catch exception,err_msg:%s" % traceback.format_exc())
            return dict()
