#!/usr/bin/env python
# -*- coding: utf-8 -*-
import os
import sys
import logging
import traceback
import time
from libs.tools import tzlc
from pypinyin import lazy_pinyin


class ProductTransfer(object):

    @classmethod
    def get_product_data(cls, instance):
        try:
            res = dict()

            res["id"] = instance.id
            res["is_online"] = instance.is_online
            res["is_deleted"] = instance.is_deleted
            res["create_time"] = tzlc(instance.create_time)
            res["update_time"] = tzlc(instance.update_time)
            res["create_time_val"] = int(time.mktime(instance.create_time.timetuple()))
            res["update_time_val"] = int(time.mktime(instance.update_time.timetuple()))
            res["price"] = instance.price
            res["cn_name_sort"] = ''
            for i in lazy_pinyin(instance.cn_name):
                res["cn_name_sort"] += str(i[0])

            res["cn_name_pre"] = instance.cn_name
            res["en_name_pre"] = instance.en_name
            res["alias_pre"] = instance.alias
            res["cn_name"] = instance.cn_name
            res["en_name"] = instance.en_name
            res["alias_pre"] = instance.alias


            res['description'] = instance.description
            res["have_image"] = True if instance.image else False
            res["comment_nums"] = instance.comment_nums
            result_name = instance.get_brand_name()
            if result_name:
                res["brand_cn_name"] = result_name.get("cn_name", "")
                res["brand_en_name"] = result_name.get("en_name", "")
                res["brand_alias"] = result_name.get("alias", "")
                res["brand_cn_name_pre"] = result_name.get("cn_name", "")
                res["brand_en_name_pre"] = result_name.get("en_name", "")
                res["brand_alias_pre"] = result_name.get("alias", "")
            else:
                res["brand_cn_name"] = ""
                res["brand_en_name"] = ""
                res["brand_alias"] = ""
                res["brand_cn_name_pre"] = ""
                res["brand_en_name_pre"] = ""
                res["brand_alias_pre"] = ""

            category_cn_name = instance.get_category_en_name()
            if category_cn_name:
                res["category_cn_name"] = category_cn_name
                res["category_cn_name_pre"] = category_cn_name
            else:
                res["category_cn_name"] = []
                res["category_cn_name_pre"] = []

            effect_cn_name = instance.get_effect_cn_name()
            if effect_cn_name:
                res['effect_cn_name'] = effect_cn_name
                res['effect_cn_name_pre'] = effect_cn_name
            else:
                res["effect_cn_name"] = []
                res["effect_cn_name_pre"] = []

            logging.info("get product:%s" % res)
            return res
        except:
            logging.error("catch exception,err_msg:%s" % traceback.format_exc())
            return dict()
