#!/usr/bin/env python
# -*- coding: utf-8 -*-

from django.conf import settings
from django.core.management.base import BaseCommand, CommandError
import traceback
import logging
from libs.es import ESPerform
from trans2es.type_info import get_type_info_map, TypeInfo
from vest.reply import true_comment_one, true_comment_two, true_comment_three
from vest.click import true_click_five, true_click_two, true_click_four, true_click_one, true_click_three
from vest.follow import auto_follow, auto_follow_new
from vest.urge import auto_star_urge, auto_lunch_app, auto_lunch_app2, auto_urge1, auto_urge2
from vest.fix import fix_no_comment_click
from vest.reply_answer import reply_comment2, reply_comment3, answer_reply2, answer_reply3, answer_reply1


class Command(BaseCommand):
    args = ''
    help = 'dump mapping to elasticsearch'

    from optparse import make_option

    option_list = BaseCommand.option_list + (
        make_option('-t', '--type', dest='type', help='type name to dump data to elasticsearch', metavar='TYPE',
                    default=''),
        make_option('-T', '--indices_template', dest='indices_template',
                    help='index template name to dump data to elasticsearch', metavar='TYPE',
                    default=''),
        make_option('-i', '--index-prefix', dest='index_prefix', help='index name to dump data to elasticsearch',
                    metavar='INDEX_PREFIX'),
        make_option('-p', '--parallel', dest='parallel', help='parallel process count', metavar='PARALLEL'),
        make_option('-s', '--pks', dest='pks', help='specify sync pks, comma separated', metavar='PKS', default=''),
        make_option('--streaming-slicing', dest='streaming_slicing', action='store_true', default=True),
        make_option('--no-streaming-slicing', dest='streaming_slicing', action='store_false', default=True),
        make_option('-m', '--mvest', dest='mvest', help='mvest reply comment', metavar='MVEST'),

    )

    def handle(self, *args, **options):
        try:

            logging.info("get-------------")
            es_cli = ESPerform.get_cli()

            type_name_list = get_type_info_map().keys()
            for type_name in type_name_list:

                if len(options["type"]):
                    if options["type"] == "all" or type_name == options["type"]:
                        official_index_name = ESPerform.get_official_index_name(type_name)
                        index_exists = es_cli.indices.exists(official_index_name)
                        if not index_exists:
                            logging.info("begin create [%s] index!" % type_name)
                            ESPerform.create_index(es_cli, type_name)

                        logging.info("begin create [%s] mapping!" % type_name)
                        ESPerform.put_index_mapping(es_cli, type_name, force_sync=True)

            if len(options["indices_template"]):
                template_file_name = options["indices_template"]
                if ESPerform.put_indices_template(es_cli=es_cli, template_file_name=template_file_name,
                                                  template_name=template_file_name):
                    logging.info("put indices template suc!")
                else:
                    logging.error("put indices template err!")

            # 点赞
            if options["mvest"] == "true_click_one":

                true_click_one.true_click_one()
            if options["mvest"] == "true_click_two":
                true_click_two.true_click_two()
            if options["mvest"] == "true_click_three":
                true_click_three.true_click_three()
            if options["mvest"] == "true_click_four":
                true_click_four.true_click_four()
            if options["mvest"] == "true_click_five":
                true_click_five.true_click_five()

            # 评论
            if options["mvest"] == "true_click_one":
                true_comment_one.true_comment_one()
            if options["mvest"] == "true_click_two":
                true_comment_two.true_comment_two()
            if options["mvest"] == "true_click_three":
                true_comment_three.true_comment_three()

            # 催更
            if options["mvest"] == "auto_urge1":
                auto_urge1.auto_urge1()
            if options["mvest"] == "auto_urge2":
                auto_urge2.auto_urge2()
            if options["mvest"] == "auto_lunch_app":
                auto_lunch_app.auto_lunch_app()
            if options["mvest"] == "auto_lunch_app2":
                auto_lunch_app2.auto_lunch_app2()
            if options["mvest"] == "auto_lunch_app2":
                auto_star_urge.auto_star_urge()

            # 关注
            if options["mvest"] == "auto_follow":
                auto_follow.auto_follow()
            if options["mvest"] == "auto_follow_new":
                auto_follow_new.auto_follow_new()

            # 补足
            if options["mvest"] == "fix_no_comment_click":
                fix_no_comment_click.fix_no_comment_click()

            # 二级评论
            if options["mvest"] == "answer_reply1":
                answer_reply1.answer_reply1()
            if options["mvest"] == "answer_reply2":
                answer_reply2.answer_reply2()
            if options["mvest"] == "answer_reply3":
                answer_reply3.answer_reply3()
            if options["mvest"] == "reply_comment2":
                reply_comment2.reply_comment2()
            if options["mvest"] == "reply_comment3":
                reply_comment3.reply_comment3()



        except:
            logging.error("catch exception,err_msg:%s" % traceback.format_exc())
