import traceback
import logging
from trans2es.models.topic import TopicTag, TopicImage, CommunityTopicProduct, Topic
from django.conf import settings
from trans2es.models.pictorial import PictorialTag
from random import randint
from trans2es.models.user_extra import UserExtra
from django.db import models


def get_edit_tag_id_list(topic_id):
    try:
        tag_id_list = TopicTag.objects.using(settings.SLAVE_DB_NAME).filter(topic_id=topic_id,
                                                                            is_collection=1).values_list("tag_id",
                                                                                                         flat=True)
        return tag_id_list
    except:
        logging.error("catch exception,err_msg:%s" % traceback.format_exc())
        return []


def topic_has_image(topic_id):
    try:
        has_image = False

        query_list = TopicImage.objects.using(settings.SLAVE_DB_NAME).filter(topic_id=topic_id, is_deleted=False,
                                                                             is_online=True)
        if len(query_list) > 0:
            has_image = True

        return has_image
    except:
        logging.error("catch exception,err_msg:%s" % traceback.format_exc())
        return False


def get_topic_product_info(topic_id):
    try:
        has_product = False

        query_list = CommunityTopicProduct.objects.using(settings.SLAVE_DB_NAME).filter(topic_id=topic_id,
                                                                                        is_deleted=False)
        if len(query_list) > 0:
            has_product = True

        return has_product
    except:
        logging.error("catch exception,err_msg:%s" % traceback.format_exc())
        return []


def get_pictorial_tag_by_id(pictorial_id):
    try:
        tag_id_list = list(PictorialTag.objects.filter(pictorial_id=pictorial_id, is_online=True, is_collection=1).values_list("tag_id", flat=True))

        return tag_id_list
    except:
        logging.error("catch exception,err_msg:%s" % traceback.format_exc())
        return []


# def get_topic_data(numtime, numitme2):
#     try:
#
#         result_topic = Topic.objects.filter(create_time__lte=numitme2, create_time__gte=numtime,
#                                             is_online=True).values("user_id", "id")
#
#         if len(result_topic) > 0:
#             for i in result_topic:
#                 shadow_judge = UserExtra.objects.filter(user_id=i[0], is_online=Topic, is_deleted=False).values_list(
#                     "is_shadow", flat=True)
#
#         return shadow_judge
#     except:
#         logging.error("catch exception,err_msg:%s" % traceback.format_exc())
#         return []


def get_recomment_data():
    try:
        last = Topic.objects.count() - 1
        index1 = randint(0, last)
        MyObj1 = Topic.objects.all()[index1]


    except:
        logging.error("catch exception,err_msg:%s" % traceback.format_exc())
        return []
