#!/usr/bin/env python
# -*- coding: utf-8 -*-

from gm_rpcd.all import bind
import logging
import traceback
from search.utils.topic import TopicUtils


@bind("physical/search/home_recommend")
def home_recommend(user_id=-1,offset=0,size=10):
    """
    :remark:首页推荐，目前只推荐日记
    :return:
    """
    try:
        # 获取user_id 关注的用户集合
        attention_user_id_list = list()
        # 获取user_id pick的用户集合
        pick_user_id_list = list()
        # 参与的小组发帖
        # 马甲账号集合
        vest_account_list = list()

        result_dict = TopicUtils.get_related_user_info(user_id,offset,size)
        

        q = dict()
        q["filter"] = {
            "range":{"content_level":{"gte":3,"lte":5}}
        }
        query_function_score = dict()
        functions = [
            {
                "filter":{"match":{"user_id":attention_user_id_list}},
                "weight": 5,
            },
            {
                "filter":{"match":{"user_id":pick_user_id_list}},
                "weight":3
            },
            {
                "filter": {"match": {"user_id": vest_account_list}},
                "weight": 0.5
            },
            {
                "filter":{"match":{"content_level":5}},
                "weight":5
            },
            {
                "filter":{"match":{"content_level":4}},
                "weight":3
            },
            {
                "filter":{"match":{"content_level":3}},
                "weight":2
            }
        ]




    except:
        logging.error("catch exception,err_msg:%s" % traceback.format_exc())

