#!/usr/bin/env python
# -*- coding: utf-8 -*-

import logging
import traceback
import json
import time
from libs.es import ESPerform


class UserUtils(object):
    @classmethod
    def get_attention_user_list(cls,user_id_list,self_user_id):
        """
        :remark 获取指定用户列表 关注的 用户列表
        :param user_id:
        :return:
        """
        try:
            q = dict()
            q["query"] = {
                "terms":{
                    "user_id":user_id_list
                }
            }
            q["_source"] = {
                "include":["attention_user_id_list","user_id"]
            }

            result_dict = ESPerform.get_search_results(ESPerform.get_cli(), "user", q, offset=0, size=len(user_id_list))

            self_attention_user_id_list = []
            recursion_attention_user_id_list = []
            for hit_item in result_dict["hits"]:
                if hit_item["_source"]["user_id"] == self_user_id:
                    self_attention_user_id_list = [item["user_id"] for item in hit_item["_source"]["attention_user_id_list"]]
                else:
                    recursion_attention_user_id_list = [item["user_id"] for item in hit_item["_source"]["attention_user_id_list"]]

            return (self_attention_user_id_list,recursion_attention_user_id_list)
        except:
            logging.error("catch exception,err_msg:%s" % traceback.format_exc())
            return ([],[])

    @classmethod
    def ___get_should_term_list(cls,ori_list,field_name="tag_list"):
        try:
            should_term_list = list()
            for term_id in ori_list:
                term_dict = {
                    "term":{
                        field_name:{"value":term_id}
                    }
                }
                should_term_list.append(term_dict)
            return should_term_list
        except:
            logging.error("catch exception,err_msg:%s" % traceback.format_exc())
            return []

    @classmethod
    def get_recommend_user_list(cls,self_attention_user_id_list,recursion_attention_user_id_list,offset,size):
        """
        :remark 获取推荐用户列表
        :param attention_user_id_list:
        :param recursion_attention_user_id_list:
        :return:
        """
        try:
            q = dict()
            q["query"] = dict()

            # recursion_attention_user_list = cls.___get_should_term_list(recursion_attention_user_id_list,field_name="user_id")

            functions_list = [
                {
                    "gauss": {
                        "latest_topic_time_val": {
                            "origin": int(time.time()),
                            "scale": "600",
                            "decay": 0.1
                        }
                    }
                }
            ]

            if len(recursion_attention_user_id_list) > 0:
                functions_list.append(
                    {
                        "filter":{
                            "bool":{
                                "should":{"terms":{"user_id":recursion_attention_user_id_list}}
                            }
                        },
                        "weight":10
                    }
                )

            query_function_score = {
                "query": {
                    "bool": {
                        "must": [
                            {"term": {"is_recommend": True}},
                            {"term": {"is_online": True}},
                            {"term": {"is_deleted": False}},
                            {"term": {"is_shadow": False}}
                        ],
                        "must_not":{
                            "terms":{
                                "user_id":self_attention_user_id_list
                            }
                        }
                    }
                },
                "score_mode": "sum",
                "boost_mode": "sum",
                "functions": functions_list
            }
            q["query"]["function_score"] = query_function_score
            q["_source"] = {
                "include":["user_id"]
            }
            result_dict = ESPerform.get_search_results(ESPerform.get_cli(), sub_index_name="user", query_body=q,
                                                       offset=offset, size=size)

            recommend_user_list = list()
            for item in result_dict["hits"]:
                recommend_user_list.append(item["_source"]["user_id"])

            return recommend_user_list
        except:
            logging.error("catch exception,err_msg:%s" % traceback.format_exc())
            return []