#!/usr/bin/env python
# -*- coding: utf-8 -*-

from django.conf import settings
from django.core.management.base import BaseCommand, CommandError
import traceback
import logging
from libs.es import ESPerform
from django.db import models
import datetime
from .user import User

class PickUserRecord(models.Model):
    class Meta:
        verbose_name = u'用户之间pick'
        db_table = 'pickuserrecord'

    pickuser_id = models.IntegerField(verbose_name="pick user id")
    is_deleted = models.BooleanField(verbose_name="是否删除")
    is_pick = models.BooleanField(verbose_name="is_pick")
    create_time = models.DateTimeField(verbose_name=u'创建时间',default=datetime.datetime.fromtimestamp(0))
    update_time = models.DateTimeField(verbose_name=u'更新时间', default=datetime.datetime.fromtimestamp(0))
    user = models.ForeignKey(User,related_name="user_pick",verbose_name="pick用户信息")
