# -*- coding: UTF-8 -*-
# !/usr/bin/env python

import numpy as np
import redis
from libs.cache import redis_client
import logging
import traceback
import json
import pickle
from django.conf import settings
from trans2es.models.tag import CommunityTagFollow
from libs.es import ESPerform
import libs.tools as Tools
from search.utils.common import *


class UserAttentionTag(object):

    linucb_device_id_matrix_redis_prefix = "physical:linucb:device_id:"
    linucb_device_id_recommend_redis_prefix = "physical:linucb:tag_recommend:device_id:"
    linucb_device_id_recommend_topic_id_prefix = "physical:linucb:topic_recommend:device_id:"
    tag_topic_id_redis_prefix = "physical:tag_id:topic_id_list:"

    linucb_user_id_matrix_redis_prefix = "physical:linucb:user_id:"
    linucb_user_id_recommend_redis_prefix = "physical:linucb:tag_recommend:user_id:"
    linucb_user_id_recommend_topic_id_prefix = "physical:linucb:topic_recommend:user_id:"

    linucb_user_id_attention_tag_topic_id_prefix = "physical:linucb:attention_tag_topic_recommend:user_id:"
    @classmethod
    def get_register_user_tag(cls,pk_list):
        try:
            user_id_set = set()
            query_results = CommunityTagFollow.objects.filter(pk__in=pk_list)
            for item in query_results:
                tag_id = item.tag_id
                user_id = item.user_id

                if user_id not in user_id_set:
                    user_id_set.add(user_id)

                    user_tag_list = CommunityTagFollow.objects.filter(user_id=user_id).order_by("-create_time").values_list("tag_id",flat=True)

                    have_read_topic_id_list = Tools.get_have_read_topic_id_list(-1, user_id,
                                                                                TopicPageType.HOME_RECOMMEND)
                    recommend_topic_id_list = list()
                    cycle_num = int(10000/len(user_tag_list))
                    for index in range(0,cycle_num):
                        for tag_id in user_tag_list:
                            redis_tag_id_key = cls.tag_topic_id_redis_prefix + str(tag_id)
                            redis_tag_id_data = redis_client.get(redis_tag_id_key)
                            tag_topic_id_list = json.loads(redis_tag_id_data) if redis_tag_id_data else []
                            if not redis_tag_id_data:
                                tag_topic_id_list = ESPerform.get_tag_topic_list(tag_id)
                                redis_client.set(redis_tag_id_key,json.dumps(tag_topic_id_list))
                                redis_client.expire(redis_tag_id_key,1*24*60*60)

                            if len(tag_topic_id_list)>index:
                                for topic_id in tag_topic_id_list[index:]:
                                    if topic_id not in have_read_topic_id_list and topic_id not in recommend_topic_id_list:
                                        recommend_topic_id_list.append(topic_id)
                                        break

                    redis_register_tag_topic_data = {
                        "data": json.dumps(recommend_topic_id_list),
                        "cursor": 0
                    }
                    redis_client.hmset(cls.linucb_user_id_attention_tag_topic_id_prefix,redis_register_tag_topic_data)
                    redis_client.expire(cls.linucb_user_id_attention_tag_topic_id_prefix,30*24*60*60)

                    topic_recommend_redis_key = cls.linucb_user_id_recommend_topic_id_prefix + str(user_id)
                    redis_recommend_topic_dict = redis_client.hgetall(topic_recommend_redis_key)

                    if len(redis_recommend_topic_dict)==0:
                        redis_data_dict = {
                            "data": json.dumps(recommend_topic_id_list),
                            "cursor":0
                        }
                        redis_client.hmset(topic_recommend_redis_key,redis_data_dict)
                        redis_client.expire(topic_recommend_redis_key,30*24*60*60)
                    else:
                        ori_recommend_topic_id_list = json.loads(redis_recommend_topic_dict["data"])
                        ori_recommend_cursor = redis_recommend_topic_dict["cursor"]

                        ori_index = 0
                        for new_recommend_index in range(0,len(recommend_topic_id_list),2):
                            pass
        except:
            logging.error("catch exception,err_msg:%s" % traceback.format_exc())
