#!/usr/bin/env python
# -*- coding: utf-8 -*-

from gm_rpcd.all import bind
import logging
import traceback
import json
from libs.cache import redis_client
from libs.es import ESPerform
from search.utils.pick import PickUtils

@bind("physical/search/pick_celebrity")
def pick_celebrity(user_id,pick_id,offset=0,size=10):
    try:
        redis_key = "physical:pick_celebrity:" + "user_id:" + str(user_id) + ":pick_id:" + str(pick_id)

        have_read_pick_celebrity_ids = list()

        try:
            redis_celebrity_info = redis_client.get(redis_key)
            have_read_pick_celebrity_ids = json.loads(redis_celebrity_info)
        except:
            logging.error("catch exception,err_msg:%s" % traceback.format_exc())

        q = dict()
        q["query"] = {
            "pick_id":pick_id,
            "bool":{
                "must_not":{
                    "terms":{
                        "id":have_read_pick_celebrity_ids
                    }
                }
            }
        }
        q["_source"] = {
            "include":["id"]
        }
        result_dict = ESPerform.get_search_results(ESPerform.get_cli(),sub_index_name="pick_celebrity",query_body=q,offset=offset,size=size)

        recommend_pick_celebrity_list = [item["id"] for item in result_dict["hits"]]
        key_exist = len(have_read_pick_celebrity_ids) > 0

        PickUtils.refresh_redis_data(have_read_celebrity_list=have_read_pick_celebrity_ids.extend(recommend_pick_celebrity_list),
                                     redis_cli=redis_client,redis_key=redis_key,key_exist=key_exist)

        return result_dict
    except:
        logging.error("catch exception,err_msg:%s" % traceback.format_exc())
        return {"total_count":0,"hits":[]}


@bind("physical/search/pick_topic")
def pick_topic(user_id,pick_id,offset=0,size=10):
    try:
        redis_key = "physical:pick_topic:" + "user_id:" + str(user_id) + ":pick_id:" + str(pick_id)

        have_read_pick_topic_ids = list()

        try:
            redis_celebrity_info = redis_client.get(redis_key)
            have_read_pick_topic_ids = json.loads(redis_celebrity_info)
        except:
            logging.error("catch exception,err_msg:%s" % traceback.format_exc())

        q = dict()
        q["filter"] = {
            "range":{"content_level":{"gte":3,"lte":5}}
        }
        query_function_score = dict()
        functions_list = [
            {
                "filter": {"match": {"content_level": 5}},
                "weight": 5
            },
            {
                "filter": {"match": {"content_level": 4}},
                "weight": 3
            },
            {
                "filter": {"match": {"content_level": 3}},
                "weight": 2
            }
        ]

        query_function_score = {
            "query":{
                "pick_id_list":[pick_id]},
            "functions":functions_list
        }

        q["query"] = {
            "funciton_score":query_function_score,
            "bool":{
                "must_not":{
                    "terms":{
                        "id":have_read_pick_topic_ids
                    }
                }
            }
        }
        q["sort"] = [
            "_score"
        ]
        q["_source"] = {
            "include":["id"]
        }
        result_dict = ESPerform.get_search_results(ESPerform.get_cli(),sub_index_name="topic",query_body=q,offset=offset,size=size)
        recommend_pick_topic_list = [item["id"] for item in result_dict["hits"]]

        key_exist = len(have_read_pick_topic_ids) > 0

        PickUtils.refresh_redis_data(have_read_celebrity_list=have_read_pick_topic_ids.extend(recommend_pick_topic_list),
                                     redis_cli=redis_client,redis_key=redis_key,key_exist=key_exist)

        return result_dict

    except:
        logging.error("catch exception,err_msg:%s" % traceback.format_exc())
        return {"total_count":0,"hits":[]}




