#!/usr/bin/env python
# -*- coding: utf-8 -*-

# from django.conf import settings
# from django.core.management.base import BaseCommand, CommandError
import traceback
import logging
from django.db import models
import datetime
import pdb


# manager = lambda: models.Manager().db_manager(using='face')


class ContrastSimilar(models.Model):
    class Meta:
        app_label = 'face'
        verbose_name = u"用户脸相似度表"
        db_table = "face_user_contrast_similar"

    id = models.IntegerField(verbose_name="主键ID", primary_key=True)
    is_online = models.BooleanField(verbose_name="是否上线")
    is_deleted = models.BooleanField(verbose_name="是否删除")
    participant_user_id = models.IntegerField(verbose_name=u'参与者用户ID')
    contrast_user_id = models.IntegerField(verbose_name="对照者用户ID")
    similarity = models.FloatField(verbose_name=u'相似度', default=0)
    create_time = models.DateTimeField(verbose_name=u'创建时间', default=datetime.datetime.fromtimestamp(0))
    update_time = models.DateTimeField(verbose_name=u'更新时间', default=datetime.datetime.fromtimestamp(0))

    def get_similar_user_id(self):

        try:

            if self.similarity > 0.3:

                similar_user_id_list = 0

                query_list = Topics.objects.filter(user_id=self.contrast_user_id, is_deleted=False,
                                                   is_online=True,
                                                   content_level__in=("3", "4", "5"))
                for item in query_list:

                    if item.user_id != self.participant_user_id:

                        similar_user_id_list = item.id

                return similar_user_id_list

        except:

            logging.error("catch exception,err_msg:%s" % traceback.format_exc())

            return None


class Topics(models.Model):
    class Meta:
        app_label = "alpha"
        verbose_name = u'日记'
        db_table = 'topic'

    id = models.IntegerField(verbose_name=u'日记ID', primary_key=True)
    user_id = models.IntegerField(verbose_name=u'用户ID')
    is_online = models.BooleanField(verbose_name=u'是否上线')
    is_deleted = models.BooleanField(verbose_name=u'是否删除')
    content_level = models.CharField(verbose_name=u'内容等级', max_length=3)
