import datetime

from django.db import models


class PictorialTopic(models.Model):
    """画报帖子关系"""

    class Meta:
        verbose_name = u'画报帖子关系'
        app_label = 'community'
        db_table = 'community_pictorial_topic'

    pictorial_id = models.BigIntegerField(verbose_name=u'画报ID')
    topic_id = models.BigIntegerField(verbose_name=u'帖子ID')
    is_online = models.BooleanField(verbose_name='是否上线')
    is_deleted = models.BooleanField(verbose_name='是否删除')
    create_time = models.DateTimeField(verbose_name=u'创建时间', default=datetime.datetime.fromtimestamp(0))
    update_time = models.DateTimeField(verbose_name=u'更新时间', default=datetime.datetime.fromtimestamp(0))
