from datetime import datetime
from utils.base import APIView
from utils.logger import error_logger
from alpha_types.venus import REPLY_TYPE, REPLY_BELONG_TYPE, USER_EXTRA_TYPE


class ReplyListView(APIView):
    def get(self, request):
        page = int(request.GET.get('page', 1))
        limit = int(request.GET.get('limit', 10))
        id_ = int(request.GET.get('id', 0))
        content = request.GET.get('content', None)
        topic_content = request.GET.get('topic_content', None)
        user_name = request.GET.get('user_name', None)
        belong_type = request.GET.get('belong_type', None)
        reply_level = request.GET.get('reply_level', None)
        reply_user_type = int(request.GET.get('reply_user_type', 0))
        replied_user_type = int(request.GET.get('replied_user_type', 0))
        is_online = request.GET.get('is_online', None)
        from_create_time = request.GET.get('from_create_time', None)
        to_create_time = request.GET.get('to_create_time', None)
        from_topic_create_time = request.GET.get('from_topic_create_time', None)
        to_topic_create_time = request.GET.get('to_topic_create_time', None)
        
        other_filters = {}
        if topic_content:
            other_filters['topic_content'] = topic_content
        if reply_user_type and reply_user_type in [USER_EXTRA_TYPE.REAL, USER_EXTRA_TYPE.SHADOW, USER_EXTRA_TYPE.KOL]:
            other_filters['reply_user_type'] = reply_user_type
        if replied_user_type and replied_user_type in [USER_EXTRA_TYPE.REAL, USER_EXTRA_TYPE.SHADOW, USER_EXTRA_TYPE.KOL]:
            other_filters['replied_user_type'] = replied_user_type
        if from_topic_create_time and to_topic_create_time:
            other_filters['topic_create_time__gte'] = from_topic_create_time
            other_filters['topic_create_time__lte'] = to_topic_create_time
        if user_name:
            other_filters['user_name'] = user_name
        filters = {}
        if id_:
            filters['id'] = id_
        if content:
            filters['content__contains'] = content
        if belong_type:
            if belong_type in REPLY_BELONG_TYPE:
                filters['belong_type'] = belong_type
        if reply_level:
            reply_level = int(reply_level)
            if reply_level == 1:
                filters['top_id__lte'] = 0
            if reply_level == 2:
                filters['top_id__gt'] = 0
        if is_online:
            is_online = int(is_online)
            filters['is_online'] = is_online
        if from_create_time and to_create_time:
            filters['create_time__gte'] = from_create_time
            filters['create_time__lte'] = to_create_time

        try:
            data = self.rpc['venus/sun/reply/list'](offset=(page-1) * limit, limit=limit, filters=filters, other_filters=other_filters).unwrap()
        except Exception as e:
            error_logger.error(u'获取reply列表失败%s', e)
            raise
        return data


class ReplyCreateView(APIView):

    def post(self, request):
        id_ = request.POST.get('id', None)
        replied_id = request.POST.get('replied_id')
        topic_id = request.POST.get('topic_id')
        pictorial_id = request.POST.get('pictorial_id')
        user_id = request.POST.get('user_id')
        content = request.POST.get('content')

        data = {
            'replied_id': replied_id,
            'topic_id': topic_id if topic_id else 0,
            'pictorial_id': pictorial_id if pictorial_id else 0,
            'user_id': user_id,
            'content': content,
            'type': REPLY_TYPE.PUPPET_REPLY_ANS,
        }
        try:
            rep = self.rpc['venus/sun/reply/edit'](id_=id_, data=data, ).unwrap()
        except Exception as e:
            error_logger.error(u'创建/编辑%s-reply信息失败%s' % (id, e))
            raise
        return {
            "message": '更新成功',
            "id": rep['id']
        }
