#!/usr/bin/env python
# -*- coding:utf-8 -*-
#
#   Author  :   RobertDing
#   E-mail  :   robertdingx@gmail.com
#   Date    :   16/03/25 11:55:13
#   Desc    :   异常类
#
from __future__ import absolute_import, division, with_statement

from gm_types.ascle.error import ERROR
from gm_types.artemis.error import ERROR as ARTEMIS_ERROR
from gm_types.error import ERROR as GAIA_ERROR


class SunException(Exception):
    """
    医生后台普通错误
    """

    def __init__(self, code=0, message=None, data=None):
        self.code = code
        self.message = message or ERROR.getDesc(code) or GAIA_ERROR.getDesc(code) or ARTEMIS_ERROR.getDesc(code)
        super().__init__(self.code, self.message)
