
import Layout from '@/views/layout/Layout'

const AdvertiseRouter = {
  path: '/advertise',
  component: Layout,
  redirect: '/advertise/list',
  name: 'Advertise',
  meta: {
    title: '通用管理',
    icon: 'component',
    roles: ['staff']
  },
  children: [
    {
      path: 'list',
      component: () => import('@/views/advertise/list'),
      name: 'AdvertiseList',
      meta: { title: '文案列表', icon: 'list' }
    },
    {
      path: 'create',
      component: () => import('@/views/advertise/create'),
      name: 'CreateAdvertise',
      meta: { title: '创建文案', icon: 'edit' }
    },
    {
      path: 'edit/:id(\\d+)',
      component: () => import('@/views/advertise/edit'),
      name: 'EditAdvertise',
      meta: { title: '编辑文案', noCache: true },
      hidden: true
    }
  ]
}

export default AdvertiseRouter
