#! /usr/bin/env python
# -*- coding: utf-8 -*-
# __author__ = "chenwei"
# Date: 2018/11/15


from django.conf.urls import url

from .pick import *
from .push import *
from .group import *
from .user import *
from .topic import *
from .star import *
from .account import *
from .search import *
from .tag import *
from .upload import *
from .token import *
from .face_star import *

urlpatterns = [
    # 登陆,注销相关
    url(r'^account/login$', LoginView.as_view()),
    url(r'^account/logout$', LogoutView.as_view()),
    url(r'^account/get$', LoginView.as_view()),
    url(r'^account/reset_password', ResetPasswordView.as_view()),

    url(r'^account/list$', AccountList.as_view()),
    url(r'^account/list/update$', AccountList.as_view()),
    url(r'^account/detail$', AccountUpdateOrCreateView.as_view()),
    url(r'^account/create$', AccountUpdateOrCreateView.as_view()),
    # user相关
    url(r'^user/list$', UserListView.as_view()),
    url(r'^user/list/update$', UserListView.as_view()),
    url(r'^user/get$', UserUpdateOrCreate.as_view()),
    url(r'^user/create$', UserUpdateOrCreate.as_view()),
    url(r'^user/group/list$', UserGroupView.as_view()),

    # group相关
    url(r'^group/list$', GroupListView.as_view()),
    url(r'^group/list/update$', GroupListView.as_view()),
    url(r'^group/get$', GroupUpdateOrCreate.as_view()),
    url(r'^group/create$', GroupUpdateOrCreate.as_view()),
    url(r'^group/user/list$', GroupRelatedUser.as_view()),
    url(r'^group/user/get$', GroupRelatedUserGET.as_view()),
    url(r'^group/user/edit_group_identify', GroupRelatedUserGET.as_view()),

    # topic相关
    url(r'^topic/list$', TopicListView.as_view()),
    url(r'^topic/detail$', TopicUpdateOrCreateView.as_view()),
    url(r'^topic/create$', TopicUpdateOrCreateView.as_view()),
    url(r'^topic/batch_update$', TopicListBatchUpdate.as_view()),
    url(r'^topic/reply/list$', ReplyUpdateOrCreateView.as_view()),
    url(r'^topic/reply/batch_delete$', ReplyUpdateOrCreateView.as_view()),
    url(r'^topic/reply/create$', ReplyCreate.as_view()),

    # star相关
    url(r'^celebrity/list$', CelebrityListView.as_view()),
    url(r'^celebrity/list/update$', CelebrityListView.as_view()),
    url(r'^celebrity/create$', CelebrityUpdateOrCreate.as_view()),
    url(r'^celebrity/detail$', CelebrityUpdateOrCreate.as_view()),
    url(r'^celebrity/celebrity_related_group_info', CelebrityRelatedGroup.as_view()),

    # push相关
    url(r'^push/list$', PushListView.as_view()),
    url(r'^push/create', PushUpdateOrCreateView.as_view()),
    url(r'^push/detail', PushUpdateOrCreateView.as_view()),
    url(r'^push/effect_push', EffectPushTaskView.as_view()),

    # pick相关
    url(r'^pick/list$', PickListView.as_view()),
    url(r'^pick/list/update$', PickListView.as_view()),
    url(r'^pick/create$', UpdateOrCreateView.as_view()),
    url(r'^pick/detail/', UpdateOrCreateView.as_view()),
    url(r'^pick/topic/list$', PickTopicView.as_view()),
    url(r'^pick/celebrity/list$', PickCelebrityListView.as_view()),
    url(r'^pick/add_fake_pick_nums$', PickUserListView.as_view()),
    url(r'^pick/topic', PickTopicView.as_view()),
    url(r'^pick/celebrity', PickCelebrityListView.as_view()),
    url(r'^pick/del_celebrity', PickCelebrityListView.as_view()),
    url(r'^pick/del_topic', PickTopicView.as_view()),

    # 标签相关
    url(r'^tag/list$', TagListView.as_view()),
    url(r'^tag/list/update$', TagListView.as_view()),
    url(r'^tag/create$', TagUpdateOrCreateView.as_view()),
    url(r'^tag/detail$', TagUpdateOrCreateView.as_view()),

    url(r'^face/star/create', FaceStarEdit.as_view()),
]

search_urlpatterns = [
    url(r'search/group$', GroupSearchView.as_view()),
    url(r'search/country', CountrySearchView.as_view()),
    url(r'search/user', UserSearchView.as_view()),
    url(r'search/tag', TagSearchView.as_view()),
    url(r'search/celebrity', CelebritySearchView.as_view()),
    url(r'search/city', CitySearchView.as_view()),
    url(r'search/topic', TopicSearchView.as_view()),
]

common_urlpatterns = [
    url(r"^file/upload$", FileUpload.as_view()),
    url(r"^get_token/$", QiniuToken.as_view()),
]

urlpatterns += search_urlpatterns
urlpatterns += common_urlpatterns
