/*
 * Decompiled with CFR 0.152.
 */
package com.meituan.android.walle;

import com.meituan.android.walle.ApkSigningPayload;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.List;

class ApkSigningBlock {
    private final List<ApkSigningPayload> payloads = new ArrayList<ApkSigningPayload>();

    ApkSigningBlock() {
    }

    public final List<ApkSigningPayload> getPayloads() {
        return this.payloads;
    }

    public void addPayload(ApkSigningPayload payload) {
        this.payloads.add(payload);
    }

    public long writeApkSigningBlock(DataOutput dataOutput) throws IOException {
        long length = 24L;
        for (int index = 0; index < this.payloads.size(); ++index) {
            ApkSigningPayload payload = this.payloads.get(index);
            byte[] bytes = payload.getByteBuffer();
            length += (long)(12 + bytes.length);
        }
        ByteBuffer byteBuffer = ByteBuffer.allocate(8);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        byteBuffer.putLong(length);
        byteBuffer.flip();
        dataOutput.write(byteBuffer.array());
        for (int index = 0; index < this.payloads.size(); ++index) {
            ApkSigningPayload payload = this.payloads.get(index);
            byte[] bytes = payload.getByteBuffer();
            byteBuffer = ByteBuffer.allocate(8);
            byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
            byteBuffer.putLong(bytes.length + 4);
            byteBuffer.flip();
            dataOutput.write(byteBuffer.array());
            byteBuffer = ByteBuffer.allocate(4);
            byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
            byteBuffer.putInt(payload.getId());
            byteBuffer.flip();
            dataOutput.write(byteBuffer.array());
            dataOutput.write(bytes);
        }
        byteBuffer = ByteBuffer.allocate(8);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        byteBuffer.putLong(length);
        byteBuffer.flip();
        dataOutput.write(byteBuffer.array());
        byteBuffer = ByteBuffer.allocate(8);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        byteBuffer.putLong(2334950737559900225L);
        byteBuffer.flip();
        dataOutput.write(byteBuffer.array());
        byteBuffer = ByteBuffer.allocate(8);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        byteBuffer.putLong(3617552046287187010L);
        byteBuffer.flip();
        dataOutput.write(byteBuffer.array());
        return length;
    }
}

